/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.OldOutputParser;
import ciss.phase_viewer.mainpanel.Desk;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;

public class NfenergyParser
extends OldOutputParser {
    private int numColumns;
    private int numRows;
    private int numEig = 0;
    private int numBands = 0;
    private int nspin = 1;
    private final String UP = "UP";
    private final String DOWN = "DOWN";
    private String updown = "UP";
    private int numKpoints = 0;
    private final int numKdata = 5;
    private boolean isColumnNameSet = false;
    private Vector colNametmp = new Vector();
    private Vector kinfo = new Vector();
    private Vector eigUp = new Vector();
    private Vector eigDown = new Vector();
    private double dk = 0.0;
    private double dkp = 0.0;
    private double dkxp = 0.0;
    private double dkyp = 0.0;
    private double dkzp = 0.0;
    private double korigin = 0.0;
    private boolean iskoriginSet = false;
    private double[][] bvec = new double[3][3];
    private boolean calrk = false;
    private String projdir = new String();
    private String FS = System.getProperty("file.separator");
    private String defaultkinPath = String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer" + this.FS + "templates" + this.FS + "kpoints";

    public NfenergyParser(String filename) {
        super(filename);
        this.colNametmp.addElement("ik");
        this.colNametmp.addElement("kx");
        this.colNametmp.addElement("ky");
        this.colNametmp.addElement("kz");
        File file = new File(filename);
        this.projdir = file.getParent();
        file = new File(String.valueOf(this.projdir) + System.getProperty("file.separator") + "bandkpoint.in");
        if (file.exists()) {
            this.readBandKpointIn(file);
        } else {
            this.askForBandKpointIn();
        }
        this.colNametmp.addElement("|k|");
    }

    private void readBandKpointIn(File file) {
        String readString = new String();
        this.calrk = true;
        try {
            System.out.println("reading " + file + " ...");
            FileReader freader = new FileReader(file);
            BufferedReader rein = new BufferedReader(freader);
            readString = rein.readLine();
            System.out.println(readString);
            int i = 0;
            while (i < 3) {
                readString = rein.readLine();
                System.out.println(readString);
                StringTokenizer st = new StringTokenizer(readString);
                this.bvec[i][0] = Double.parseDouble(st.nextToken());
                this.bvec[i][1] = Double.parseDouble(st.nextToken());
                this.bvec[i][2] = Double.parseDouble(st.nextToken());
                ++i;
            }
            rein.close();
            freader.close();
        }
        catch (Exception e) {
            System.out.println("failed read from: " + file);
            this.calrk = false;
        }
    }

    private void askForBandKpointIn() {
        Object[] init = new Object[]{"specify input file", "ignore"};
        Component component = null;
        ImageIcon icon = new ImageIcon("logo.png");
        int ret = JOptionPane.showInternalOptionDialog(Desk.getDesktop(), "couldn't find input file for band_kpoint.pl!", "warning", 0, 2, null, init, init[0]);
        if (ret == 0) {
            ChaseFileChooser fdlg = new ChaseFileChooser();
            fdlg.setDialogType(2);
            fdlg.setDialogTitle("Open");
            fdlg.setCurrentDirectory(new File(this.projdir));
            fdlg.setFileSelectionMode(0);
            if (fdlg.showDialog(component, "open") != 0) {
                System.out.println("no specification for bandkpoint.in ...");
                this.calrk = false;
            } else {
                String bandkpointin = fdlg.getSelectedFile().getAbsolutePath();
                this.readBandKpointIn(new File(bandkpointin));
            }
        } else {
            System.out.println("no specification for bandkpoint.in ...");
            this.calrk = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parseString(String str) {
        block21: {
            block25: {
                block24: {
                    block23: {
                        block22: {
                            block20: {
                                st = new StringTokenizer(str);
                                strdata = new String();
                                bloopisData = false;
                                if (!str.trim().startsWith("num_kpoints")) break block20;
                                st.nextToken();
                                st.nextToken();
                                try {
                                    this.numKpoints = Integer.parseInt(st.nextToken());
                                }
                                catch (Exception e) {
                                    System.out.println("invalid num_kpoints!");
                                }
                                this.addHeader(str);
                                this.addHeader(OldOutputParser.CR);
                                bloopisData = false;
                                break block21;
                            }
                            if (!str.trim().startsWith("num_bands")) break block22;
                            st.nextToken();
                            st.nextToken();
                            try {
                                this.numBands = Integer.parseInt(st.nextToken());
                            }
                            catch (Exception e) {
                                System.out.println("invalid num_bands!");
                            }
                            this.addHeader(str);
                            this.addHeader(OldOutputParser.CR);
                            bloopisData = false;
                            break block21;
                        }
                        if (!str.trim().startsWith("nspin")) break block23;
                        st.nextToken();
                        st.nextToken();
                        try {
                            this.nspin = Integer.parseInt(st.nextToken());
                        }
                        catch (Exception e) {
                            System.out.println("invalid nspin!");
                        }
                        this.addHeader(str);
                        this.addHeader(OldOutputParser.CR);
                        bloopisData = false;
                        break block21;
                    }
                    if (!str.trim().startsWith("Valence")) break block24;
                    this.addHeader(str);
                    this.addHeader(OldOutputParser.CR);
                    bloopisData = false;
                    break block21;
                }
                if (!str.trim().startsWith("===")) break block25;
                bloopisData = false;
                break block21;
            }
            if (!str.trim().startsWith("Fermi")) ** GOTO lbl121
            bloopisData = false;
            this.addHeader(str);
            this.addHeader(OldOutputParser.CR);
            break block21;
lbl-1000:
            // 1 sources

            {
                strdata = st.nextToken();
                if (strdata.trim().startsWith("ik")) {
                    st.nextToken();
                    ik = st.nextToken();
                    st.nextToken();
                    kx = st.nextToken();
                    ky = st.nextToken();
                    kz = st.nextToken();
                    if (kz.endsWith(")")) {
                        ch = kz.toCharArray();
                        kz = new String(ch, 0, ch.length - 1);
                    }
                    next = st.nextToken();
                    if (this.nspin == 2) {
                        this.updown = next;
                    }
                    if (this.updown.equals("UP")) {
                        this.kinfo.addElement(ik);
                        this.kinfo.addElement(kx);
                        this.kinfo.addElement(ky);
                        this.kinfo.addElement(kz);
                        if (this.calrk) {
                            dkx = Double.parseDouble(kx);
                            dky = Double.parseDouble(ky);
                            dkz = Double.parseDouble(kz);
                            dkc = new double[3];
                            i = 0;
                            while (i < 3) {
                                dkc[i] = this.bvec[i][0] * (this.dkxp - dkx) + this.bvec[i][1] * (this.dkyp - dky) + this.bvec[i][2] * (this.dkzp - dkz);
                                ++i;
                            }
                            this.dk = this.dkp + Math.sqrt(Math.pow(dkc[0], 2.0) + Math.pow(dkc[1], 2.0) + Math.pow(dkc[2], 2.0));
                            if (!this.iskoriginSet) {
                                this.korigin = this.dk;
                                this.iskoriginSet = true;
                            }
                            this.kinfo.addElement(Double.toString(this.dk - this.korigin));
                            this.dkxp = dkx;
                            this.dkyp = dky;
                            this.dkzp = dkz;
                            this.dkp = this.dk;
                        } else {
                            this.kinfo.addElement("0.0");
                        }
                    }
                    bloopisData = false;
                    return;
                }
                ++this.numEig;
                bloopisData = true;
                if (this.updown.equals("UP")) {
                    this.eigUp.addElement(strdata);
                } else if (this.updown.equals("DOWN")) {
                    this.eigDown.addElement(strdata);
                }
                if (this.isColumnNameSet) continue;
                if (this.nspin == 1) {
                    this.colNametmp.addElement("eig" + this.numEig);
                    continue;
                }
                if (this.nspin != 2) continue;
                this.colNametmp.addElement("eig" + this.numEig + " " + this.updown);
lbl121:
                // 5 sources

                ** while (st.hasMoreTokens())
            }
        }
        if (bloopisData && this.numEig == this.numBands * this.nspin) {
            this.isColumnNameSet = true;
            this.numEig = 0;
        }
    }

    @Override
    protected void processData() {
        int numcols = this.colNametmp.size();
        int i = 0;
        while (i < numcols) {
            this.addColumnName((String)this.colNametmp.get(i));
            ++i;
        }
        this.setNumColumns(numcols);
        int numData = this.kinfo.size();
        int numLoop = numData / 5;
        int i2 = 0;
        while (i2 < numLoop) {
            int j = 0;
            while (j < 5) {
                this.addDataColumn((String)this.kinfo.get(i2 * 5 + j));
                ++j;
            }
            j = 0;
            while (j < this.numBands) {
                this.addDataColumn((String)this.eigUp.get(i2 * this.numBands + j));
                ++j;
            }
            if (this.nspin == 2) {
                j = 0;
                while (j < this.numBands) {
                    this.addDataColumn((String)this.eigDown.get(i2 * this.numBands + j));
                    ++j;
                }
            }
            this.addDataRow();
            ++i2;
        }
    }
}

