/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.pmodel;

import ciss.phase_viewer.atomcoord.pmodel.Atom;
import ciss.phase_viewer.atomcoord.pmodel.Cif;
import ciss.phase_viewer.atomcoord.pmodel.PmodelException;
import ciss.phase_viewer.atomcoord.pmodel.PointGroupOperation;
import ciss.phase_viewer.atomcoord.pmodel.SpaceGroup;
import java.util.ArrayList;

public class Pmodel {
    private static final boolean DEBUG = false;
    private static final double EPS = 1.0E-13;
    private static final double criticalDistance = 0.1;
    private SpaceGroup sg;
    private Cif cif = new Cif();
    private double[][] cellMatrix = new double[3][3];
    private double[] ttl = new double[6];
    ArrayList<Atom> atomList = new ArrayList(100);

    public int getIntTablesNum() {
        return this.cif.getIntTablesNum();
    }

    public int getNumSymmetryEquivPosInCif() {
        return this.cif.symmetryEquivPos.size();
    }

    public String getHermannMauguin() {
        return this.cif.getHermannMauguin();
    }

    public void makeSpaceGroup() throws PmodelException {
        PointGroupOperation.PointGroup pg_ = this.getPG();
        this.sg = new SpaceGroup(pg_, this.cif.symmetryEquivPos);
    }

    public void makeSpaceGroup(int choice) throws PmodelException {
        this.sg = new SpaceGroup(this.getIntTablesNum(), choice);
    }

    public void readCIF(String fileName, int ndb) throws PmodelException {
        this.cif.read(fileName, ndb);
    }

    public PointGroupOperation.PointGroup getPG() {
        double eps = 5.0E-5;
        double[] cellAngle = this.cif.getCellAngle();
        double[] cellLength = this.cif.getCellLength();
        switch (this.cif.getCrystalSystem()) {
            case TRICLINIC: 
            case MONOCLINIC: 
            case ORTHORHOMBIC: 
            case TETRAGONAL: 
            case CUBIC: {
                return PointGroupOperation.PointGroup.Oh;
            }
            case TRIGONAL: 
            case RHOMBOHEDRAL: 
            case HEXAGONAL: {
                return PointGroupOperation.PointGroup.D6h;
            }
        }
        int sgn = this.getIntTablesNum();
        if (sgn > 0) {
            return PointGroupOperation.getPointGroup(sgn);
        }
        PointGroupOperation.PointGroup pg_ = PointGroupOperation.PointGroup.D6h;
        if (cellLength[0] != cellLength[1]) {
            pg_ = PointGroupOperation.PointGroup.Oh;
        }
        if (Math.abs(cellAngle[0] - 90.0) > 5.0E-5) {
            pg_ = PointGroupOperation.PointGroup.Oh;
        }
        if (Math.abs(cellAngle[1] - 90.0) > 5.0E-5) {
            pg_ = PointGroupOperation.PointGroup.Oh;
        }
        if (Math.abs(cellAngle[2] - 120.0) > 5.0E-5) {
            pg_ = PointGroupOperation.PointGroup.Oh;
        }
        return pg_;
    }

    public void makeLattice() throws PmodelException {
        double temp;
        int j;
        double[] cellAngle = this.cif.getCellAngle();
        double[] cellLength = this.cif.getCellLength();
        int[] nc = new int[1];
        double alpha = cellAngle[0] * Math.PI / 180.0;
        double beta = cellAngle[1] * Math.PI / 180.0;
        double gamma = cellAngle[2] * Math.PI / 180.0;
        int i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                this.cellMatrix[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        this.cellMatrix[0][0] = 1.0;
        this.cellMatrix[0][1] = Math.cos(gamma);
        this.cellMatrix[0][2] = Math.cos(beta);
        this.cellMatrix[1][1] = Math.sin(gamma);
        this.cellMatrix[1][2] = temp = (Math.cos(alpha) - Math.cos(beta) * Math.cos(gamma)) / Math.sin(gamma);
        this.cellMatrix[2][2] = Math.sqrt(Math.sin(beta) * Math.sin(beta) - temp * temp);
        i = 0;
        while (i < 3) {
            j = 0;
            while (j < 3) {
                double[] dArray = this.cellMatrix[i];
                int n = j;
                dArray[n] = dArray[n] * cellLength[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            this.ttl[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < 3) {
            int k = (i + 1) % 3;
            j = 0;
            while (j < 3) {
                int n = i;
                this.ttl[n] = this.ttl[n] + this.cellMatrix[j][i] * this.cellMatrix[j][i];
                int n2 = i + 3;
                this.ttl[n2] = this.ttl[n2] + this.cellMatrix[j][i] * this.cellMatrix[j][k];
                ++j;
            }
            ++i;
        }
        this.expandAtoms();
        this.eliminateDuplicateAtoms();
    }

    private void expandAtoms() {
        int i = 0;
        while (i < this.cif.atomList.size()) {
            int j = 0;
            while (j < this.sg.pointGroupOperation.getNg0()) {
                if (this.sg.isActive(j)) {
                    Atom atm = this.sg.pointGroupOperation.rotate(this.cif.atomList.get(i), j);
                    int k = 0;
                    while (k < 4) {
                        if (this.sg.transVec[j][k] != null) {
                            this.atomList.add(this.sg.transVec[j][k].shift(atm));
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void eliminateDuplicateAtoms() {
        int i = 0;
        int count = 0;
        while (i < this.atomList.size() - 1) {
            int j = i + 1;
            while (j < this.atomList.size()) {
                if (this.isDuplicate(i, j)) {
                    this.atomList.remove(j);
                    ++count;
                    continue;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean isDuplicate(int m, int n) {
        return this.distanceSq(m, n) < 0.010000000000000002;
    }

    private double distanceSq(int m, int n) {
        double[] diff = new double[3];
        int i = 0;
        while (i < 3) {
            double a = this.atomList.get((int)m).position[i];
            double b = this.atomList.get((int)n).position[i];
            double temp = a - b;
            while (temp < -0.5) {
                temp += 1.0;
            }
            while (temp > 0.5) {
                temp -= 1.0;
            }
            diff[i] = temp;
            ++i;
        }
        double dis = 0.0;
        i = 0;
        while (i < 3) {
            int j = (i + 1) % 3;
            dis += this.ttl[i] * diff[i] * diff[i] + 2.0 * this.ttl[i + 3] * diff[i] * diff[j];
            ++i;
        }
        return dis;
    }

    public double[] getCellAngle() {
        return this.cif.getCellAngle();
    }

    public double[] getCellLength() {
        return this.cif.getCellLength();
    }

    public int getNumberOfAtoms() {
        return this.atomList.size();
    }

    public String[] getSymbol() {
        int numAtom = this.getNumberOfAtoms();
        String[] symbol = new String[numAtom];
        int i = 0;
        while (i < numAtom) {
            symbol[i] = this.atomList.get((int)i).symbol;
            ++i;
        }
        return symbol;
    }

    public String[] getAlias() {
        int numAtom = this.getNumberOfAtoms();
        String[] alias = new String[numAtom];
        int i = 0;
        while (i < numAtom) {
            alias[i] = this.atomList.get((int)i).alias;
            ++i;
        }
        return alias;
    }

    public double[][] getInternalPosition() {
        int numAtom = this.getNumberOfAtoms();
        double[][] pos = new double[numAtom][3];
        int i = 0;
        while (i < numAtom) {
            int j = 0;
            while (j < 3) {
                pos[i][j] = this.atomList.get((int)i).position[j];
                ++j;
            }
            ++i;
        }
        return pos;
    }

    public double[][] getCellVec() {
        double[][] cellVec = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                cellVec[i][j] = this.cellMatrix[j][i];
                if (Math.abs(cellVec[i][j]) < 1.0E-13) {
                    cellVec[i][j] = 0.0;
                }
                ++j;
            }
            ++i;
        }
        return cellVec;
    }
}

