/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.atomcoord.io.CubeFileFilter;
import ciss.phase_viewer.atomcoord.io.Exporter;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ElementInfo;
import ciss.phase_viewer.common.Utils;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CubeExporter
implements Exporter {
    private Logger logger = Logger.getLogger((String)CubeExporter.class.getName());
    private double ang2bohr = ConstParameters.ANG_2_BOHR;

    @Override
    public boolean writeAtomCoordsTo(AtomCoords[] coords, String fileName) {
        int i;
        AtomCoords coord = coords[0];
        coord.convert(6, 9);
        PrintWriter writer = Utils.getPrintWriter(fileName);
        writer.println("Gaussian cube file created by the PHASE-Viewer");
        writer.println("volumetric data");
        writer.println(String.valueOf(String.valueOf(coord.getNumAt())) + " 0.0 0.0 0.0");
        VolumetricData vdata = coord.getChargeDensity();
        vdata.stripPBC();
        int[] ndiv = vdata.getNumDiv();
        float[][] delta = vdata.getDelta();
        float[] density = vdata.getDensity();
        ElementInfo info = new ElementInfo();
        try {
            i = 0;
            while (i < 3) {
                writer.println(String.valueOf(ndiv[i]) + " " + (double)delta[i][0] * this.ang2bohr + " " + (double)delta[i][1] * this.ang2bohr + " " + (double)delta[i][2] * this.ang2bohr);
                ++i;
            }
        }
        catch (ArrayIndexOutOfBoundsException aobe) {
            this.logger.error((Object)"invalid ndiv and/or delta.");
            return false;
        }
        i = 0;
        while (i < coord.getNumAt()) {
            Atom atom = coord.getAtomList().getAtomAt(i);
            if (atom.getDouble() == null || atom.getDouble().length < 3) {
                this.logger.error((Object)"invalid atom pos ");
                return false;
            }
            writer.println(String.valueOf(info.getNumberFromSymbol(atom.getElementName())) + " " + atom.getNumValenceElectrons() + " " + atom.getDouble()[0] + " " + atom.getDouble()[1] + " " + atom.getDouble()[2]);
            ++i;
        }
        int numRow = density.length / 6;
        int i2 = 0;
        while (i2 < numRow) {
            int j = 0;
            while (j < 6) {
                writer.print(" " + density[i2 * 6 + j]);
                ++j;
            }
            writer.print(System.getProperty("line.separator"));
            ++i2;
        }
        i2 = numRow * 6;
        while (i2 < density.length) {
            writer.print(" " + density[i2]);
            ++i2;
        }
        writer.print(System.getProperty("line.separator"));
        writer.flush();
        writer.close();
        vdata.doPBC(density, ndiv);
        return true;
    }

    @Override
    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    @Override
    public FileFilter getFileFilter() {
        return new CubeFileFilter();
    }

    @Override
    public String getType() {
        return "Gaussian Cube";
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public void setOptions(HashMap options) {
    }
}

