/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord.io;

import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.io.ChaseFileFilter;
import ciss.phase_viewer.atomcoord.io.Importer;
import ciss.phase_viewer.jdom.XMLUtils;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ChaseImporter
implements Importer {
    private Logger logger = Logger.getLogger((String)ChaseImporter.class.getName());

    @Override
    public AtomCoords[] getAtomCoordsFrom(String fileName) {
        Document document = XMLUtils.getDocumentFromFile(new File(fileName));
        Element root = document.getRootElement();
        List frame = root.getChildren("frame");
        if (frame == null || frame.size() == 0) {
            this.logger.error((Object)"no frame found in file!");
            return null;
        }
        AtomCoords[] coords = new AtomCoords[frame.size()];
        int i = 0;
        while (i < frame.size()) {
            coords[i] = new AtomCoords();
            Element fr = (Element)frame.get(i);
            String iscart = fr.getAttribute("iscart").getValue();
            coords[i].isCart(new Boolean(iscart));
            String length = fr.getAttribute("lengthunit").getValue();
            int un = coords[i].getUnitInt(length);
            coords[i].setUnit(un);
            Element atlist = fr.getChild("atomlist");
            AtomList list = coords[i].getAtomList();
            list.createFrom(atlist);
            Element elemcell = fr.getChild("cell");
            Cell[] cell = Cell.createFrom(elemcell);
            coords[i].setCell(cell);
            ++i;
        }
        return coords;
    }

    @Override
    public void createOptionsPanel(boolean heavy, PropertyChangeListener listener, String fileName) {
    }

    @Override
    public boolean hasOptions() {
        return false;
    }

    @Override
    public String getType() {
        return "phase-viewer";
    }

    @Override
    public FileFilter getFileFilter() {
        return new ChaseFileFilter();
    }

    @Override
    public void setOptions(HashMap options) {
    }

    @Override
    public boolean isImportable(String fileName) {
        if (new File(fileName).isDirectory()) {
            return false;
        }
        return this.getFileFilter().accept(new File(fileName));
    }
}

