/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.scenegraphelements.CapableText2D;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElement;
import com.sun.j3d.utils.geometry.Sphere;
import java.awt.Font;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

class LegendObject
extends SceneGraphElement {
    private static Logger logger = Logger.getLogger((String)LegendObject.class.getName());
    private int numAt = 1;
    private String[] elements;
    private String[] elementall;
    private int numEl = 100;
    private float[][] colors;
    private int numNodes = 30;

    @Override
    public int getType() {
        return 4;
    }

    @Override
    public void configDataUpdate() {
        try {
            this.setElements(this.mCD.getElements());
            this.setNumAt(this.mCD.getNumAt());
            this.setElements(this.mCD.getElements());
            this.setNumEl(this.mACVD.getNumEl());
            this.setElementAll(this.mACVD.getElement());
            this.setColor(this.mACVD.getColor());
            this.setNumNodes(this.mACVD.getNumNodesAtom());
            this.removeAllChildren();
            this.create();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void create() {
        if (this.numAt == 0) {
            return;
        }
        String[] DistinctElement = new String[this.numAt];
        int[] DistinctElementIndex = new int[this.numAt];
        float shift = 0.15f;
        boolean bdistinct = true;
        int k = 0;
        int iDistinct = 0;
        int i = 0;
        while (i < this.numAt) {
            DistinctElement[i] = "";
            DistinctElementIndex[i] = 0;
            ++i;
        }
        DistinctElement[0] = this.elements[0];
        DistinctElementIndex[0] = 0;
        iDistinct = 1;
        i = 1;
        while (i < this.numAt) {
            bdistinct = true;
            k = 0;
            while (k < iDistinct) {
                if (DistinctElement[k].equals(this.elements[i])) {
                    bdistinct = false;
                }
                ++k;
            }
            if (bdistinct) {
                DistinctElement[iDistinct] = this.elements[i];
                ++iDistinct;
            }
            ++i;
        }
        i = 0;
        while (i < iDistinct) {
            k = 0;
            while (k < this.numEl) {
                if (this.elementall[k].equals(DistinctElement[i])) {
                    DistinctElementIndex[i] = k;
                }
                ++k;
            }
            ++i;
        }
        float[] color_wk = new float[3];
        i = 0;
        while (i < iDistinct) {
            k = 0;
            while (k < 3) {
                color_wk[k] = this.colors[DistinctElementIndex[i]][k];
                ++k;
            }
            logger.debug((Object)("color for legend no. " + i + ": " + color_wk[0] + " " + color_wk[1] + " " + color_wk[2]));
            Appearance app = new Appearance();
            RenderingAttributes ra = new RenderingAttributes();
            ra.setIgnoreVertexColors(true);
            app.setRenderingAttributes(ra);
            Material material = new Material();
            material.setDiffuseColor(new Color3f(color_wk));
            material.setShininess(120.0f);
            app.setMaterial(material);
            Color3f fontColor = this.mACVD.getFontColor();
            Font font = this.mACVD.getFont();
            CapableText2D text2D = new CapableText2D("   " + DistinctElement[i], fontColor, font.getName(), font.getSize(), font.getStyle());
            Transform3D translate = new Transform3D();
            translate.set(new Vector3f(-0.93f, 0.8f - (float)i * shift, 0.0f));
            translate.setScale(1.0);
            TransformGroup tfgl = new TransformGroup(translate);
            tfgl.addChild((Node)text2D);
            BranchGroup tmpbg = new BranchGroup();
            tmpbg.setCapability(17);
            tmpbg.addChild((Node)tfgl);
            this.addChild((Node)tmpbg);
            Transform3D translateat = new Transform3D();
            translateat.set(new Vector3f(-0.93f, 0.84f - (float)i * shift, 0.0f));
            translateat.setScale(1.0);
            Sphere sphere1 = new Sphere(0.04f, 1, this.numNodes, app);
            TransformGroup tfg = new TransformGroup(translateat);
            tfg.addChild((Node)sphere1);
            BranchGroup bg = new BranchGroup();
            bg.setCapability(17);
            bg.addChild((Node)tfg);
            this.addChild((Node)bg);
            logger.debug((Object)("finished creating legend no. " + i));
            ++i;
        }
    }

    protected void setNumAt(int numAt) {
        this.numAt = numAt;
    }

    protected void setElements(String[] elements) {
        this.elements = elements;
    }

    protected void setElementAll(String[] elementall) {
        this.elementall = elementall;
    }

    protected void setNumEl(int numEl) {
        this.numEl = numEl;
    }

    protected void setColor(float[][] colors) {
        this.colors = colors;
    }

    protected void setNumNodes(int numNodes) {
        logger.debug((Object)("numNodes: " + numNodes));
        this.numNodes = numNodes;
    }
}

