/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.acviewer.scenegraphelements.CylinderCreatorTG;
import ciss.phase_viewer.acviewer.scenegraphelements.SceneGraphElementBG;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.util.Vector;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class CellObject
extends SceneGraphElementBG {
    private Logger logger = Logger.getLogger((String)CellObject.class.getName());
    private double[] cellOrigin;
    private double[][] cellVec;
    private double[] cellOffset;
    private double[][] CellTyo;
    private int numNodes = 30;
    private float cellWidth = 0.005f;
    private WignerSeitzCell wscell;
    boolean recreate = false;
    private BranchGroup primitiveCell;
    private Vector transforms;

    @Override
    public int getType() {
        return 2;
    }

    public void createWSCell() {
        Point3f avec = new Point3f();
        Point3f bvec = new Point3f();
        Point3f cvec = new Point3f();
        Point3f origin = new Point3f();
        double lenmax = (float)this.mCD.getLenMax();
        avec.x = (float)(this.cellVec[0][0] / lenmax);
        avec.y = (float)(this.cellVec[0][1] / lenmax);
        avec.z = (float)(this.cellVec[0][2] / lenmax);
        bvec.x = (float)(this.cellVec[1][0] / lenmax);
        bvec.y = (float)(this.cellVec[1][1] / lenmax);
        bvec.z = (float)(this.cellVec[1][2] / lenmax);
        cvec.x = (float)(this.cellVec[2][0] / lenmax);
        cvec.y = (float)(this.cellVec[2][1] / lenmax);
        cvec.z = (float)(this.cellVec[2][2] / lenmax);
        WignerSeitzAttributes wsattrs = new WignerSeitzAttributes();
        wsattrs.isReciprocalSpace = false;
        this.wscell = new WignerSeitzCell(avec, bvec, cvec, wsattrs);
        this.addChild((Node)this.wscell);
    }

    public WignerSeitzCell getWSCell() {
        return this.wscell;
    }

    public void nullifyWSCell() {
        this.wscell = null;
    }

    public void recreate(double[] cellOrigin, double[][] cellVec) {
    }

    @Override
    protected void create() {
        this.create(false);
    }

    protected void create(boolean recreate) {
        this.recreate = recreate;
        double lenmax = this.mCD.getLenMax();
        this.cellOrigin = this.mCD.getCellOriginVector(this.mACVD.getShiftPolicy());
        this.cellVec = this.mCD.getCell();
        if (this.cellVec == null) {
            return;
        }
        this.CellTyo = new double[8][3];
        this.logger.debug((Object)"creating cell");
        this.logger.debug((Object)"cellvec:");
        this.logger.debug((Object)("avec: " + this.cellVec[0][0] + " " + this.cellVec[0][1] + " " + this.cellVec[0][2]));
        this.logger.debug((Object)("bvec: " + this.cellVec[1][0] + " " + this.cellVec[1][1] + " " + this.cellVec[1][2]));
        this.logger.debug((Object)("cvec: " + this.cellVec[2][0] + " " + this.cellVec[2][1] + " " + this.cellVec[2][2]));
        double[] offset = this.parent.getCellOffset();
        this.removeAllChildren();
        double[] oo = new double[3];
        double[][] celve = new double[3][3];
        int i = 0;
        while (i < 3) {
            oo[i] = this.cellOrigin[i] / lenmax + offset[i];
            int j = 0;
            while (j < 3) {
                celve[i][j] = this.cellVec[i][j] / lenmax;
                ++j;
            }
            ++i;
        }
        this.CellTyo = this.getVertices(oo, celve);
        this.transforms = new Vector();
        TransformGroup t = new TransformGroup();
        t.setCapability(17);
        t.setCapability(18);
        t.setCapability(12);
        this.transforms.add(t);
        float[] col = this.mACVD.getCellColor();
        this.addChild((Node)this.createCell(0, 1, this.CellTyo, col));
        this.addChild((Node)this.createCell(0, 2, this.CellTyo, col));
        this.addChild((Node)this.createCell(1, 3, this.CellTyo, col));
        this.addChild((Node)this.createCell(2, 3, this.CellTyo, col));
        this.addChild((Node)this.createCell(4, 6, this.CellTyo, col));
        this.addChild((Node)this.createCell(4, 5, this.CellTyo, col));
        this.addChild((Node)this.createCell(6, 7, this.CellTyo, col));
        this.addChild((Node)this.createCell(5, 7, this.CellTyo, col));
        this.addChild((Node)this.createCell(0, 4, this.CellTyo, col));
        this.addChild((Node)this.createCell(2, 6, this.CellTyo, col));
        this.addChild((Node)this.createCell(1, 5, this.CellTyo, col));
        this.addChild((Node)this.createCell(3, 7, this.CellTyo, col));
    }

    private double[][] getVertices(double[] origin, double[][] vector) {
        double[][] ret = new double[8][3];
        int i = 0;
        while (i < 3) {
            ret[0][i] = origin[i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[1][i] = vector[0][i] + ret[0][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[2][i] = vector[1][i] + ret[0][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[3][i] = vector[0][i] + vector[1][i] + ret[0][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[4][i] = vector[2][i] + ret[0][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[5][i] = vector[0][i] + vector[2][i] + ret[0][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[6][i] = vector[1][i] + vector[2][i] + ret[0][i];
            ++i;
        }
        i = 0;
        while (i < 3) {
            ret[7][i] = vector[1][i] + vector[2][i] + vector[0][i] + ret[0][i];
            ++i;
        }
        return ret;
    }

    public void addPrimitiveCell() {
        if (!(this.mACVD.getParent() instanceof MainPanel)) {
            return;
        }
        ACVData data = ((CoordsViewerInterface)((Object)this.mACVD.getParent())).getData();
        BravaisLattice bl = data.getBravaisLattice();
        if (bl == null) {
            return;
        }
        double[][] cell = bl.getPrimitiveLatticeVector();
        double[] ori = this.mCD.getCellOriginVector(this.mACVD.getShiftPolicy());
        double[] off = this.parent.getCellOffset();
        double[] tmpori = new double[3];
        int i = 0;
        while (i < 3) {
            tmpori[i] = ori[i] / this.mCD.getLenMax() + off[i];
            ++i;
        }
        double[][] tmpvec = new double[3][3];
        int i2 = 0;
        while (i2 < 3) {
            int j = 0;
            while (j < 3) {
                tmpvec[i2][j] = cell[i2][j] / this.mCD.getLenMax();
                ++j;
            }
            ++i2;
        }
        double[][] vertices = this.getVertices(tmpori, tmpvec);
        if (this.primitiveCell != null) {
            this.primitiveCell.detach();
        }
        this.primitiveCell = new BranchGroup();
        this.primitiveCell.setCapability(17);
        GlobalProperties props = PropertiesManager.getGlobalProperties(1);
        float[] col = new float[]{0.0f, 0.0f, 0.0f};
        try {
            col[0] = Float.parseFloat(props.getProperty("primitive_cell_color_r"));
            col[1] = Float.parseFloat(props.getProperty("primitive_cell_color_g"));
            col[2] = Float.parseFloat(props.getProperty("primitive_cell_color_b"));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.primitiveCell.addChild((Node)this.createCell(0, 1, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(0, 2, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(1, 3, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(2, 3, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(4, 6, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(4, 5, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(6, 7, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(5, 7, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(0, 4, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(2, 6, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(1, 5, vertices, col));
        this.primitiveCell.addChild((Node)this.createCell(3, 7, vertices, col));
        this.addChild((Node)this.primitiveCell);
    }

    public void removePrimitiveCell() {
        if (this.primitiveCell != null) {
            this.primitiveCell.detach();
        }
    }

    @Override
    public void configDataUpdate() {
        this.logger.debug((Object)"at configDataUpdate()");
        if (this.cellVec == null) {
            this.logger.debug((Object)"cellvec is null...");
            return;
        }
        double[][] cellVec_tmp = this.mCD.getCell();
        if (cellVec_tmp == null) {
            return;
        }
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                if (this.cellVec[i][j] != cellVec_tmp[i][j]) {
                    this.create(true);
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void configDataUpdate(boolean foo, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    protected void setNumNodes(int numNodes) {
        this.numNodes = numNodes;
    }

    protected void setCellWidth(float cellWidth) {
        this.cellWidth = cellWidth;
    }

    private BranchGroup createCell(int i1, int i2, double[][] vertices, float[] cellcolor) {
        double[] CellHen = new double[6];
        int i = 0;
        while (i < 3) {
            CellHen[i] = vertices[i1][i];
            CellHen[i + 3] = vertices[i2][i];
            ++i;
        }
        Appearance app = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(cellcolor));
        material.setShininess(120.0f);
        app.setMaterial(material);
        Point3d Cyl1 = new Point3d(CellHen[0], CellHen[1], CellHen[2]);
        Point3d Cyl2 = new Point3d(CellHen[3], CellHen[4], CellHen[5]);
        CylinderCreatorTG cylindercreateTG = new CylinderCreatorTG(Cyl1, Cyl2);
        cylindercreateTG.setColor(new Color3f(cellcolor));
        cylindercreateTG.setRadius(this.mACVD.getCellWidth());
        cylindercreateTG.setResolution(this.mACVD.getNumNodesCell());
        cylindercreateTG.setMode(CylinderCreatorTG.CYLINDER);
        if (this.mACVD.getUseWireForCell()) {
            cylindercreateTG.setMode(CylinderCreatorTG.WIRE);
        }
        cylindercreateTG.create();
        BranchGroup cylinder = new BranchGroup();
        cylinder.setCapability(17);
        cylinder.setCapability(12);
        cylinder.addChild((Node)cylindercreateTG);
        this.transforms.add(cylindercreateTG);
        return cylinder;
    }

    public TransformGroup[] getTransforms() {
        Object[] ret = new TransformGroup[this.transforms.size()];
        this.transforms.copyInto(ret);
        return ret;
    }
}

