/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.operations;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomList;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.common.VectorOperations;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UnitCellOperations {
    public static Logger logger = Logger.getLogger((String)UnitCellOperations.class.getName());
    private Vector frames;
    private double eps = 1.0E-5;
    private boolean packAtoms = false;
    private boolean ab = false;
    private boolean ac = false;
    private boolean bc = false;
    private int curframe;
    private CoordsViewerInterface parent;

    public UnitCellOperations(Vector frames, CoordsViewerInterface parent) {
        this.frames = frames;
        this.parent = parent;
    }

    public UnitCellOperations(AtomCoords coord, CoordsViewerInterface parent) {
        this.frames = new Vector();
        this.frames.add(coord);
        this.parent = parent;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setPackAtomsIntoUnitCell(boolean packAtoms) {
        this.packAtoms = packAtoms;
    }

    public void setAddBoundaryAtoms(boolean ab, boolean ac, boolean bc) {
        this.ab = ab;
        this.ac = ac;
        this.bc = bc;
    }

    public void processFrame() {
        AtomCoords cds;
        int i = 0;
        while (i < this.frames.size()) {
            cds = (AtomCoords)this.frames.elementAt(i);
            cds.removeBoundaryAtoms();
            ++i;
        }
        if (!(this.packAtoms || this.ab || this.ac || this.bc)) {
            return;
        }
        if (this.frames == null) {
            logger.error((Object)"'frames' vector is null.");
            return;
        }
        if (this.frames.size() == 0) {
            logger.error((Object)"no frames.");
            return;
        }
        i = 0;
        while (i < this.frames.size()) {
            cds = (AtomCoords)this.frames.elementAt(i);
            if (this.packAtoms) {
                UnitCellOperations.packAtomsIntoCell(cds);
            }
            if (this.ab || this.ac || this.bc) {
                this.addBoundaryAtoms(cds);
            }
            ++i;
        }
    }

    public void processFrame(AtomCoords cds) {
        if (!(this.packAtoms || this.ab || this.ac || this.bc)) {
            return;
        }
        if (this.packAtoms) {
            UnitCellOperations.packAtomsIntoCell(cds);
        }
        if (this.ab || this.ac || this.bc) {
            this.addBoundaryAtoms(cds);
        }
    }

    public static void packAtomsIntoCell(AtomCoords cds) {
        AtomList atomList = cds.getAtomList();
        double[][] cell = cds.getCellDouble(0);
        double[] cellOrigin = cds.getCell()[0].getCellOffset();
        if (cell == null) {
            logger.error((Object)"invalid cell!");
            return;
        }
        double[][] plane01 = new double[2][3];
        double[][] plane02 = new double[2][3];
        double[][] plane12 = new double[2][3];
        plane01[0] = cell[0];
        plane01[1] = cell[1];
        plane02[0] = cell[2];
        plane02[1] = cell[0];
        plane12[0] = cell[1];
        plane12[1] = cell[2];
        int nat = atomList.size();
        double[] orig = new double[3];
        double[][] pospos = cds.getPosDouble();
        double[][] shiftedCell = new double[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                orig[j] = -cellOrigin[j];
                shiftedCell[i][j] = cell[i][j] + orig[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < nat) {
            int j;
            double[] pos = pospos[i];
            double r01 = VectorOperations.getDistanceFromPlane(pos, plane01[0], plane01[1], orig, true);
            double r10 = VectorOperations.getDistanceFromPlane(pos, plane01[1], plane01[0], shiftedCell[2], true);
            double r02 = VectorOperations.getDistanceFromPlane(pos, plane02[0], plane02[1], orig, true);
            double r20 = VectorOperations.getDistanceFromPlane(pos, plane02[1], plane02[0], shiftedCell[1], true);
            double r12 = VectorOperations.getDistanceFromPlane(pos, plane12[0], plane12[1], orig, true);
            double r21 = VectorOperations.getDistanceFromPlane(pos, plane12[1], plane12[0], shiftedCell[0], true);
            if (r01 < 0.0) {
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] + cell[2][j];
                    ++j;
                }
            } else if (r10 < 0.0) {
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] - cell[2][j];
                    ++j;
                }
            }
            if (r02 < 0.0) {
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] + cell[1][j];
                    ++j;
                }
            } else if (r20 < 0.0) {
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] - cell[1][j];
                    ++j;
                }
            }
            if (r12 < 0.0) {
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] + cell[0][j];
                    ++j;
                }
            } else if (r21 < 0.0) {
                j = 0;
                while (j < 3) {
                    int n = j;
                    pos[n] = pos[n] - cell[0][j];
                    ++j;
                }
            }
            pospos[i] = pos;
            ++i;
        }
        cds.setPosDouble(pospos, true);
    }

    private void addBoundaryAtoms(AtomCoords cds) {
        Cell cell = cds.getCell()[0];
        AtomList atomList = cds.getAtomList();
        double[] cellOrigin = cds.getCell()[0].getCellOffset();
        if (this.parent.getCD() == null) {
            return;
        }
        double[][] dcell = this.parent.getCD().getCell();
        double[][] plane1 = new double[2][3];
        double[][] plane2 = new double[2][3];
        logger.debug((Object)("size of atomlist: " + atomList.size()));
        int natm = atomList.size();
        double[][] plane = new double[2][3];
        if (this.ab) {
            plane[0] = dcell[0];
            plane[1] = dcell[1];
            this.addAtomToOppositePlane(plane, dcell[2], cds);
        }
        if (this.ac) {
            plane[0] = dcell[0];
            plane[1] = dcell[2];
            this.addAtomToOppositePlane(plane, dcell[1], cds);
        }
        if (this.bc) {
            plane[0] = dcell[1];
            plane[1] = dcell[2];
            this.addAtomToOppositePlane(plane, dcell[0], cds);
        }
    }

    private void addAtomToOppositePlane(double[][] plane, double[] shiftVector, AtomCoords cds) {
        double[] origcell = cds.getCell()[0].getCellOffset();
        double[] shiftedCell = new double[3];
        double[] orig = new double[3];
        int j = 0;
        while (j < 3) {
            orig[j] = -origcell[j];
            shiftedCell[j] = shiftVector[j] + orig[j];
            ++j;
        }
        AtomList list = cds.getAtomList();
        Vector<Double[]> newPos = new Vector<Double[]>();
        Vector<Integer> newPosIndex = new Vector<Integer>();
        int i = 0;
        while (i < list.size()) {
            int j2;
            Double[] npos;
            double[] pos = list.getAtomAt(i).getDouble();
            double r = VectorOperations.getDistanceFromPlane(pos, plane[0], plane[1], orig);
            double rop = VectorOperations.getDistanceFromPlane(pos, plane[1], plane[0], shiftedCell);
            if (r < this.eps) {
                npos = new Double[3];
                j2 = 0;
                while (j2 < 3) {
                    npos[j2] = new Double(pos[j2] + shiftVector[j2]);
                    ++j2;
                }
                newPos.addElement(npos);
                newPosIndex.addElement(new Integer(i));
            } else if (rop < this.eps) {
                npos = new Double[3];
                j2 = 0;
                while (j2 < 3) {
                    npos[j2] = new Double(pos[j2] - shiftVector[j2]);
                    ++j2;
                }
                newPos.addElement(npos);
                newPosIndex.addElement(new Integer(i));
            }
            ++i;
        }
        if (newPos == null || newPos.size() == 0) {
            return;
        }
        int undoCount = 0;
        int i2 = 0;
        while (i2 < newPos.size()) {
            Double[] npos = (Double[])newPos.elementAt(i2);
            double[] tmp = new double[3];
            int j3 = 0;
            while (j3 < 3) {
                tmp[j3] = npos[j3];
                ++j3;
            }
            int posIndex = (Integer)newPosIndex.elementAt(i2);
            Atom atom = cds.getAtomList().getAtomAt(posIndex);
            Atom newAtom = atom.getCopy();
            newAtom.setPos(tmp);
            newAtom.isBoundaryAtom(true);
            if (!cds.checkDupli(newAtom)) {
                cds.getAtomList().addAtom(newAtom);
                ++undoCount;
            }
            ++i2;
        }
        cds.getAtomList().setUndoCount(undoCount);
    }
}

