/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.operations;

import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.AtomEvent;
import ciss.phase_viewer.atomcoord.AtomListener;
import java.util.Arrays;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BasicOperations
implements AtomListener {
    private Logger logger = Logger.getLogger((String)BasicOperations.class.getName());
    private TGAtom tgatom;
    private MainPanel parent;
    private boolean wait = false;

    public BasicOperations(MainPanel parent) {
        this.parent = parent;
        this.tgatom = (TGAtom)parent.getRootTransform();
    }

    public void removeAtoms(AtomObject[] atoms) {
        if (atoms == null || atoms.length == 0) {
            return;
        }
        AtomCoords coords = this.tgatom.getConfigData().getAtomCoords();
        coords.saveState();
        Vector<Integer> indexVector = new Vector<Integer>();
        int i = 0;
        while (i < atoms.length) {
            int id = Integer.parseInt(atoms[i].getID()) - 1;
            indexVector.addElement(new Integer(id));
            ++i;
        }
        if (indexVector.size() == 0) {
            return;
        }
        Object[] indeces = new Integer[indexVector.size()];
        indexVector.copyInto(indeces);
        Arrays.sort(indeces);
        int i2 = indeces.length - 1;
        while (i2 >= 0) {
            coords.getAtomList().removeAtomAt((Integer)indeces[i2]);
            --i2;
        }
        coords.getAtomList().setUndoCount(atoms.length);
        if (!this.wait) {
            this.redraw();
        }
    }

    public void removeSelectedAtoms() {
        AtomObject[] atoms = this.tgatom.getSelectedAtoms();
        this.removeAtoms(atoms);
    }

    private void redraw() {
        AtomCoords coords = this.tgatom.getConfigData().getAtomCoords();
        this.tgatom.getConfigData().isRenderingManual(true);
        this.parent.prepareRedraw();
        this.parent.getCD().setCoords(coords);
        this.parent.postRedraw();
        this.parent.getCD().isRenderingManual(false);
        coords.finalizeState();
        this.wait = false;
    }

    public void modifyAttributesOfSelectedAtoms(String elementName, Vector auxvec) {
        AtomObject[] selectedAtoms = this.tgatom.getSelectedAtoms();
        AtomCoords coords = this.tgatom.getConfigData().getAtomCoords();
        if (selectedAtoms == null || selectedAtoms.length == 0) {
            return;
        }
        int j = 0;
        while (j < selectedAtoms.length) {
            int id = Integer.parseInt(selectedAtoms[j].getID()) - 1;
            Atom at = coords.getAtomList().getAtomAt(id);
            if (elementName.trim().length() != 0) {
                at.setElementName(elementName);
            }
            if (auxvec.size() != 0) {
                at.setAuxil(auxvec);
            }
            ++j;
        }
        if (!this.wait) {
            this.redraw();
        }
    }

    public void translateSelectedAtoms(double x, double y, double z) {
        AtomObject[] selectedAtoms = this.tgatom.getSelectedAtoms();
        AtomCoords coords = this.tgatom.getConfigData().getAtomCoords();
        int i = 0;
        while (i < selectedAtoms.length) {
            int id = Integer.parseInt(selectedAtoms[i].getID()) - 1;
            double[] pos = this.parent.getCD().getPos(id);
            pos[0] = pos[0] + x;
            pos[1] = pos[1] + y;
            pos[2] = pos[2] + z;
            Atom atnow = coords.getAtomList().getAtomAt(id);
            Atom newatom = atnow.getCopy();
            newatom.setPos(pos);
            coords.getAtomList().replaceAtomAt(id, newatom);
            ++i;
        }
        coords.getAtomList().setUndoCount(selectedAtoms.length);
        if (!this.wait) {
            this.redraw();
        }
    }

    public void wait(boolean wait) {
        this.wait = wait;
    }

    public void doUpdate() {
        this.redraw();
    }

    @Override
    public void atomStateChanged(AtomEvent e) {
        Atom atom = e.getAtom();
        int ind = e.getIndex();
        AtomCoords coords = this.parent.getCD().getAtomCoords();
        this.logger.debug((Object)("atom now: " + coords.getAtomList().getAtomAt(ind)));
        Atom at = coords.getAtomList().getAtomAt(ind);
        Atom newat = at.getCopy();
        newat.setElementName(atom.getElementName());
        newat.setPos(atom.getPos());
        newat.setAuxil(atom.getAuxil());
        coords.replaceAtomAt(ind, newat);
        this.logger.debug((Object)("AtomStateChanged: " + e));
        if (!this.wait) {
            this.redraw();
        }
    }
}

