/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.colormap;

import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import java.awt.Color;
import org.apache.log4j.Logger;

public class SimpleColorMap
extends BaseColorMap {
    private Logger logger = Logger.getLogger((String)SimpleColorMap.class.getName());

    @Override
    public Color getColor(float value) {
        if (value < 0.0f) {
            return Color.BLUE;
        }
        if (value > 1.0f) {
            return Color.RED;
        }
        if ((double)value >= 0.75 && (double)value <= 1.0) {
            float val = 1.0f - value;
            float green = val / 0.25f;
            return new Color(1.0f, green, 0.0f);
        }
        if ((double)value >= 0.5 && (double)value < 0.75) {
            float val = 0.75f - value;
            float red = 1.0f - val / 0.25f;
            return new Color(red, 1.0f, 0.0f);
        }
        if ((double)value >= 0.25 && (double)value < 0.5) {
            float val = 0.5f - value;
            float blue = val / 0.25f;
            return new Color(0.0f, 1.0f, blue);
        }
        if (value >= 0.0f && (double)value < 0.25) {
            float val = 0.25f - value;
            float green = 1.0f - val / 0.25f;
            return new Color(0.0f, green, 1.0f);
        }
        return Color.BLACK;
    }

    @Override
    public int getResolution() {
        return 1024;
    }
}

