/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.colormap;

import ciss.phase_viewer.acviewer.colormap.ColorMap;
import ciss.phase_viewer.main.PluginLoader;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;

public abstract class BaseColorMap
implements ColorMap {
    private static Logger logger = Logger.getLogger((String)BaseColorMap.class.getName());
    protected String name;
    private static ColorMap[] cmaps = null;

    @Override
    public Color3f getColor3f(float value) {
        Color color = this.getColor(value);
        Color3f c3f = new Color3f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
        return c3f;
    }

    @Override
    public Color3f getColor3f(float value, boolean invert) {
        Color3f c3f = this.getColor3f(value);
        if (!invert) {
            return c3f;
        }
        return this.getColor3f(1.0f - value);
    }

    @Override
    public Color getColor(float value, boolean invert) {
        Color c = this.getColor(value);
        if (!invert) {
            return c;
        }
        return this.getColor(1.0f - value);
    }

    @Override
    public BranchGroup getColorBar() {
        BranchGroup bg = new BranchGroup();
        return bg;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public static double getLinearScaledValue(double min, double max, double value) {
        double minmax = max - min;
        return (value - min) / minmax;
    }

    public static double getLogScaledValue(double min, double max, double value) {
        if (min > max) {
            logger.debug((Object)"the specified minimum is larger than the specified maximum... replacing minimum and maximum.");
            double tmptmp = min;
            min = max;
            max = tmptmp;
        }
        if (min == max) {
            max = min + 1.0 - 10.0;
        }
        double tmpval = value;
        if (min <= 0.0) {
            min = 1.0E-10;
        }
        if (max <= 0.0) {
            max = 2.0E-10;
        }
        if (tmpval <= 0.0) {
            tmpval = 1.0E-10;
        }
        double lmin = Math.log(min) + 100.0;
        double lmax = Math.log(max) + 100.0;
        double lval = Math.log(tmpval) + 100.0;
        double tmp1 = 1.0 / (lmax - lmin);
        double tmp2 = lval - lmin;
        double foo = tmp1 * tmp2;
        return foo;
    }

    public static double getValueFromLinearScaledValue(double min, double max, double scaledValue) {
        return min + (max - min) * scaledValue;
    }

    public static double getValueFromLogScaledValue(double min, double max, double scaledValue) {
        if (scaledValue >= 1.0) {
            return max;
        }
        if (scaledValue <= 0.0) {
            return min;
        }
        if (min > max) {
            logger.warn((Object)"the specified minimum is larger than the specified maximum... replacing minimum and maximum.");
            double tmptmp = min;
            min = max;
            max = tmptmp;
        }
        if (min == max) {
            max = min + 1.0 - 10.0;
        }
        if (min <= 0.0) {
            min = 1.0E-10;
        }
        if (max <= 0.0) {
            max = 2.0E-10;
        }
        double lmin = Math.log(min) + 100.0;
        double lmax = Math.log(max) + 100.0;
        double foo = (lmax - lmin) * scaledValue + lmin - 100.0;
        double ret = Math.exp(foo);
        return ret;
    }

    public static ColorMap[] getSupportedColorMaps() {
        if (cmaps == null) {
            Vector<Object> objs = new Vector<Object>();
            try {
                InputStream is = BaseColorMap.class.getResourceAsStream("/ciss/phase_viewer/acviewer/colormap/supported.properties");
                BufferedReader breader = new BufferedReader(new InputStreamReader(is));
                String line = "";
                while ((line = breader.readLine()) != null) {
                    String[] foo;
                    if ((line = line.trim()).startsWith("#") || (foo = line.split("=")) == null || foo.length < 2) continue;
                    String na = foo[0];
                    String path = foo[1];
                    Object obj = PluginLoader.instantiate(path, null);
                    ((BaseColorMap)obj).name = na.replaceAll("_", " ");
                    objs.addElement(obj);
                }
                breader.close();
                is.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            cmaps = new ColorMap[objs.size()];
            objs.copyInto(cmaps);
        }
        return cmaps;
    }
}

