/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ACVButtons;
import ciss.phase_viewer.acviewer.ACVData;
import ciss.phase_viewer.acviewer.ACVMenuBar;
import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.RectangleCreator;
import ciss.phase_viewer.acviewer.Show3D;
import ciss.phase_viewer.acviewer.Stoppable;
import ciss.phase_viewer.acviewer.mouselistener.ACVMouseMotionListener;
import ciss.phase_viewer.acviewer.operations.BasicOperations;
import ciss.phase_viewer.acviewer.operations.UnitCellOperations;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.mainpanel.Desk;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.VirtualUniverse;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class MainPanel
extends BaseJ3DPanel
implements ConfigData,
CoordsViewerInterface {
    private static Logger logger = Logger.getLogger((String)MainPanel.class.getName());
    private ConfigDataManager mCD;
    private Show3D s3d;
    private JDesktopPane desktop;
    private String[][] xyz;
    private String[][] cellvec;
    private String[] label;
    private int NumAt;
    private boolean cellorigin;
    private Vector frames;
    private Container cont;
    private int insetx;
    private int insety;
    private JPanel panel;
    private ACVData acvdata;
    private RectangleCreator rectangleCreator;
    private int mode = 1;
    private Animater animater = null;
    private UnitCellOperations unitcell;
    private ACVButtons btns;
    private boolean foo = false;
    private BranchGroup rootRootBranch;

    public MainPanel() {
        super("AtomicConfigurationViewer", defaultSize);
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(int mode) {
        super("AtomicConfigurationViewer", defaultSize);
        this.mode = mode;
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(ACVData acvdata) {
        super("AtomicConfigurationViewer " + acvdata.getFileName(), defaultSize);
        this.acvdata = acvdata;
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(ACVData acvdata, int mode) {
        super("AtomicConfigurationViewer " + acvdata.getFileName(), defaultSize);
        this.acvdata = acvdata;
        this.mode = mode;
        this.frames = acvdata.getFrames();
        this.parentDir = acvdata.getParentDir();
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(Vector frames, String parentDir) {
        super("AtomicConfigurationViewer", defaultSize);
        this.frames = frames;
        if (parentDir != null) {
            this.parentDir = parentDir;
        }
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    public MainPanel(Vector frames) {
        super("AtomicConfigurationViewer", defaultSize);
        this.frames = frames;
        this.init();
        this.setJMenuBar(new ACVMenuBar(this));
    }

    @Override
    public boolean supportsFrame() {
        return true;
    }

    protected void stopAllAnimations() {
        if (this.associatedGUIs != null) {
            int num = this.associatedGUIs.size();
            int i = 0;
            while (i < num) {
                Object obj = this.associatedGUIs.get(i);
                if (obj instanceof Stoppable) {
                    ((Stoppable)obj).stop();
                }
                ++i;
            }
        }
    }

    @Override
    public Animater getAssociatedAnimater() {
        if (this.animater == null) {
            this.animater = new Animater(this);
        }
        return this.animater;
    }

    @Override
    public void doUnitCell() {
        this.doUnitCell(true);
    }

    public void doUnitCell(Boolean update, Boolean bpack, Boolean bab, Boolean bac, Boolean bbc) {
        try {
            if (update.booleanValue()) {
                this.getCD().getAtomCoords().saveState();
            }
            boolean ab = new Boolean(this.prop.getProperty("add_boundary_atoms_ab"));
            boolean ac = new Boolean(this.prop.getProperty("add_boundary_atoms_ac"));
            boolean bc = new Boolean(this.prop.getProperty("add_boundary_atoms_bc"));
            boolean pack = new Boolean(this.prop.getProperty("pack_atoms_into_unit_cell"));
            if (bab != null && bac != null && bbc != null) {
                ab = bab;
                ac = bac;
                bc = bbc;
            }
            if (bpack != null) {
                pack = bpack;
            }
            String seps = this.prop.getProperty("pack_atoms_into_unit_cell_eps");
            double eps = -1.0;
            if (seps != null) {
                try {
                    eps = Double.parseDouble(seps);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.unitcell == null) {
                this.unitcell = new UnitCellOperations(this.frames, (CoordsViewerInterface)this);
            }
            if (eps >= 0.0) {
                this.unitcell.setEps(eps);
            }
            this.unitcell.setPackAtomsIntoUnitCell(pack);
            this.unitcell.setAddBoundaryAtoms(ab, ac, bc);
            this.unitcell.processFrame();
            if (update.booleanValue()) {
                this.getCD().setCoords(this.getCD().getAtomCoords());
                this.getCD().getAtomCoords().finalizeState();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void doUnitCell(boolean update) {
        this.doUnitCell(new Boolean(update), null, null, null, null);
    }

    @Override
    public void setData(ACVData data) {
        this.acvdata = data;
        this.frames = data.getFrames();
        this.parentDir = data.getParentDir();
        super.setTitle("AtomicConfigurationViewer  " + this.acvdata.getFileName());
        this.animater = null;
        int i = 0;
        while (i < this.associatedGUIs.size()) {
            Container window;
            Object editor = this.associatedGUIs.get(i);
            if (editor instanceof JInternalFrame) {
                window = (JInternalFrame)this.associatedGUIs.get(i);
                if (window != null) {
                    ((JInternalFrame)window).dispose();
                }
            } else if (editor instanceof JFrame && (window = (JFrame)this.associatedGUIs.get(i)) != null) {
                ((Window)window).dispose();
            }
            ++i;
        }
        this.init();
        this.revalidate();
    }

    @Override
    public void setFrame(Vector frames) {
        this.frames = frames;
        this.init();
    }

    @Override
    public void setFrame(AtomCoords[] cds) {
        if (cds == null) {
            return;
        }
        this.frames = new Vector();
        int i = 0;
        while (i < cds.length) {
            this.frames.addElement(cds[i]);
            ++i;
        }
        this.init();
    }

    @Override
    public UnitCellOperations getUnitCellManipulator() {
        return this.unitcell;
    }

    private void init() {
        this.desktop = Desk.getDesktop();
        if (this.frames != null && this.frames.size() != 0) {
            this.doUnitCell(false);
            this.mCD = new ConfigDataManager((AtomCoords)this.frames.get(0));
            if (this.dataManager == null) {
                logger.error((Object)"dataManager is null");
            }
            this.mCD.setJ3DDataManager(this.dataManager);
            this.mCD.register(this);
            this.mCD.setParent(this);
            this.mCD.getAtomCoords().getAtomList().initializeUndoRedo();
            this.setLabel();
        }
        this.rootBranch = new BranchGroup();
        this.rootBranch.setCapability(17);
        this.rootBranch.setCapability(12);
        this.rootBranch.setCapability(13);
        this.rootBranch.setCapability(14);
        this.s3d = new Show3D(this);
        this.rectangleCreator = new RectangleCreator(this, 0.0f, 0.0f);
        logger.debug((Object)("simpleU: " + this.simpleU));
        this.simpleU.getViewingPlatform().setPlatformGeometry(this.rectangleCreator.getPlatformGeometry(0.0f, 0.0f));
        this.rectangleCreator.detach();
        if (this.btns == null) {
            this.btns = new ACVButtons(this);
            this.getContentPane().add((Component)this.btns, "North");
        }
        this.calculateInsets();
        ACVMouseMotionListener mouseMotionListener = new ACVMouseMotionListener(this);
        if (MainPanel.useJCanvas3D()) {
            this.getJCanvas3D().addMouseMotionListener(mouseMotionListener);
            this.getJCanvas3D().addMouseListener(mouseMotionListener);
            this.getJCanvas3D().requestFocusInWindow();
        } else {
            this.getCanvas().addMouseMotionListener((MouseMotionListener)mouseMotionListener);
            this.getCanvas().addMouseListener((MouseListener)mouseMotionListener);
        }
    }

    @Override
    public void configDataUpdate() {
        this.redraw();
    }

    @Override
    public void configDataUpdate(boolean boo, ConfigDataUpdateEvent e) {
        this.redraw();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    private void calculateInsets() {
        Dimension canvdim = this.canvas3d.getSize();
        Dimension dim = this.getSize();
        this.insetx = dim.width - canvdim.width;
        this.insety = dim.height - canvdim.height;
    }

    @Override
    public TransformGroup[] getRotatingTransform() {
        return new TransformGroup[]{this.getRootTransform(), this.s3d.getTGAxis()};
    }

    @Override
    public Show3D getScene() {
        return this.s3d;
    }

    @Override
    public void postCleanUp() {
        this.s3d.cleanUp();
        this.s3d = null;
        this.rectangleCreator = null;
        this.rootBranch = null;
    }

    @Override
    public Vector getFramesAC() {
        return this.frames;
    }

    @Override
    public void initializeRectangle(float fx, float fy) {
        this.rectangleCreator.setLocation(fx, fy);
    }

    @Override
    public void updateRectangle(float w, float h) {
        this.rectangleCreator.updateRectangle(w, h);
    }

    @Override
    public void finalizeRectangle() {
        this.rectangleCreator.detach();
    }

    @Override
    public void setLabel() {
        this.label = new String[this.mCD.getNumAt()];
        int i = 0;
        while (i < this.mCD.getNumAt()) {
            this.label[i] = Integer.toString(i + 1);
            ++i;
        }
        this.dataManager.setLabel(this.label);
    }

    @Override
    public final void display3D() throws Exception {
        if (this.mCD != null) {
            this.s3d.createNewElement();
            this.rootBranch = this.s3d.getObjRoot();
            this.s3d.setMouseMotionBehaviours();
            this.rootBranch.setCapability(17);
            this.rootBranch.compile();
            VirtualUniverse.setJ3DThreadPriority((int)10);
            if (this.rootRootBranch == null) {
                this.rootRootBranch = new BranchGroup();
                this.rootRootBranch.setCapability(14);
                this.rootRootBranch.setCapability(12);
                this.rootRootBranch.setCapability(13);
                this.rootRootBranch.addChild((Node)this.rootBranch);
                this.simpleU.addBranchGraph(this.rootRootBranch);
            } else {
                this.rootRootBranch.removeAllChildren();
                this.rootRootBranch.addChild((Node)this.rootBranch);
            }
            this.getContentPane().requestFocusInWindow();
            this.canvas3d.requestFocusInWindow();
            this.foo = true;
        }
        this.doUnitCell();
        this.setVisible(true);
    }

    private void setAllowIntersect(Node node) {
        if (node instanceof Shape3D) {
            try {
                ((Shape3D)node).getGeometry().setCapability(18);
            }
            catch (RestrictedAccessException restrictedAccessException) {
                // empty catch block
            }
        }
        if (node instanceof Group) {
            Group gp = (Group)node;
            int i = 0;
            while (i < gp.numChildren()) {
                Node nd = gp.getChild(i);
                this.setAllowIntersect(nd);
                ++i;
            }
        }
    }

    @Override
    public ACVData getData() {
        return this.acvdata;
    }

    @Override
    public ConfigDataManager getCD() {
        return this.mCD;
    }

    @Override
    public void selectedRow(int row) {
        if (row < 0) {
            return;
        }
        AtomObject[] aobjs = ((TGAtom)this.s3d.getTGAtom()).getAtomObjects();
        if (aobjs == null) {
            return;
        }
        int i = 0;
        while (i < aobjs.length) {
            AtomObject obj = aobjs[i];
            obj.unSelect();
            if (obj.getID().equals(Integer.toString(row + 1))) {
                logger.debug((Object)("foobar : caught atomobject: " + obj.getID()));
                obj.setSelected();
            }
            ++i;
        }
        this.calculateInsets();
    }

    @Override
    public void lightRedraw() {
        this.mCD.update();
    }

    @Override
    public void redraw() {
    }

    @Override
    public void heavyRedraw(boolean always) {
        if (!always && this.frames.size() == 1) {
            this.redraw();
            return;
        }
        logger.info((Object)"redrawing the whole scene...");
        this.removeFromDesktop();
        this.init();
        try {
            this.display3D();
        }
        catch (Exception exc) {
            logger.error((Object)"failed 'heavy' redraw");
        }
    }

    @Override
    public VolumetricData[] getAssociatedVolumetricData() {
        return this.getCD().getAtomCoords().getChargeDensities();
    }

    @Override
    public TransformGroup getRootTransform() {
        return this.getScene().getTGAtom();
    }

    @Override
    public BasicOperations getBasicOperations() {
        return ((TGAtom)this.getScene().getTGAtom()).getBasicOperations();
    }
}

