/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.ssh.remotehostexecuter;

import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFile;
import jp.advancesoft.chase.ssh.remotehostexecuter.ChaseFileProperty;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeManager;
import jp.advancesoft.chase.ssh.remotehostexecuter.FileTransferSchemeTableModel;
import jp.advancesoft.chase.ssh.remotehostexecuter.JButtonEditor;
import jp.advancesoft.chase.ssh.remotehostexecuter.JLabelRenderer;
import org.apache.log4j.Logger;

class FileTransferSchemeTable
extends JTable {
    private Logger logger = Logger.getLogger((String)FileTransferSchemeTable.class.getName());
    private FileTransferSchemeTableModel tableModel;
    private FileTransferSchemeManager manager;

    protected FileTransferSchemeTable(FileTransferSchemeTableModel tableModel, FileTransferSchemeManager manager) {
        super(tableModel);
        this.tableModel = tableModel;
        this.manager = manager;
        ChaseFile[] files = manager.getFiles();
        this.setSelectionForeground(Color.white);
        if (files == null || files.length == 0) {
            return;
        }
        ChaseFileProperty[] prop = files[0].getChaseFileProperties();
        int col = 0;
        for (int i = 0; i < prop.length; ++i) {
            JLabelRenderer jr;
            if (!prop[i].showOnTable()) continue;
            if (prop[i].getTableEditorScheme() == 1) {
                this.getColumnModel().getColumn(col).setCellEditor(new DefaultCellEditor(new JCheckBox()));
            } else if (prop[i].getTableEditorScheme() == 0) {
                jr = new JLabelRenderer("view");
                this.getColumnModel().getColumn(col).setCellRenderer(jr);
                this.getColumnModel().getColumn(col).setCellEditor(new DefaultCellEditor(new JTextField("")));
            } else if (prop[i].getTableEditorScheme() == 2) {
                jr = new JLabelRenderer("view");
                this.getColumnModel().getColumn(col).setCellEditor(new JButtonEditor("view", jr));
                this.getColumnModel().getColumn(col).setCellRenderer(jr);
            } else if (prop[i].getTableEditorScheme() == 3) {
                JComboBox<Object> combo = new JComboBox<Object>(prop[i].getItems());
                this.getColumnModel().getColumn(col).setCellEditor(new DefaultCellEditor(combo));
            }
            if (!prop[i].isEditable() && this.getColumnModel().getColumn(col).getCellEditor() instanceof DefaultCellEditor) {
                Component comp = ((DefaultCellEditor)this.getColumnModel().getColumn(col).getCellEditor()).getComponent();
                comp.setEnabled(prop[i].isEditable());
            }
            ++col;
        }
    }
}

