/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.settings;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import jp.advancesoft.chase.settings.InstallationProperties;
import org.apache.log4j.Logger;

public abstract class GlobalProperties
extends Properties {
    private static Logger logger = Logger.getLogger((String)GlobalProperties.class.getName());
    protected String fileName;
    protected int propertyType;
    protected InstallationProperties installation;
    protected final String FS = System.getProperty("file.separator");
    protected final String homeDir = System.getProperty("user.home");
    protected final String instDir = System.getProperty("chase.home");
    protected final String chaseHomeDir = this.homeDir + this.FS + ".chase";

    protected GlobalProperties() {
        this.setFileName();
        this.loadProperty();
    }

    protected GlobalProperties(InstallationProperties installation) {
        this.installation = installation;
        this.setFileName();
        this.loadProperty();
    }

    protected GlobalProperties(InstallationProperties installation, Properties defaultProperties) {
        super(defaultProperties);
        this.installation = installation;
        this.setFileName();
        this.loadProperty();
    }

    public abstract String getFileName();

    public abstract int getPropertyType();

    protected abstract void setFileName();

    private void loadProperty() {
        try {
            super.load(new FileInputStream(this.fileName));
        }
        catch (Exception exc) {
            logger.debug((Object)("failed to load from file: " + this.fileName));
        }
    }

    public void storeProperty() {
        try {
            super.store(new FileOutputStream(this.fileName), "last modification");
        }
        catch (Exception exc) {
            logger.debug((Object)("failed to store property to file: " + this.fileName));
        }
    }
}

