/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.projectbrowser;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import jp.advancesoft.chase.inputinterface.DataManager;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.outputinterface.OutputInterface;
import jp.advancesoft.chase.projectbrowser.ProjectBrowser;
import jp.advancesoft.chase.projectbrowser.fileinfo.FileInfoParser;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ProjectInfo {
    public static final int BASE = 1;
    public static final int SUB = 2;
    private static Logger logger = Logger.getLogger((String)ProjectInfo.class.getName());
    private String projdir;
    private String projectType;
    private int infoType = 1;
    private String name;
    private String date;
    private Vector subprojects = new Vector();
    private Element element;
    private FileInfoParser parser;
    private ProjectBrowser parent;
    private Document doc;
    private InputInterface inputInterface;
    private OutputInterface outputInterface;
    private DataManager dm;

    public ProjectInfo(Element element) {
        this.element = element;
        this.init();
    }

    private void init() {
        String elemName = this.element.getName();
        if (elemName.equals("project")) {
            this.infoType = 1;
        } else if (elemName.equals("subproject")) {
            this.infoType = 2;
        }
        this.name = this.element.getChildTextTrim("name");
        this.date = this.element.getChildTextTrim("date");
        this.projectType = this.element.getChildTextTrim("type");
        this.projdir = this.element.getChildTextTrim("directory");
        String hasSubs = this.element.getAttributeValue("hassub");
        boolean bhasSubs = false;
        if (hasSubs != null) {
            bhasSubs = new Boolean(hasSubs);
        }
        if (bhasSubs) {
            List list;
            String subident = this.element.getAttributeValue("subident");
            if (subident == null) {
                logger.error((Object)"invalid `subident' attribute");
            }
            if ((list = this.element.getChildren(subident)) != null) {
                for (int i = 0; i < list.size(); ++i) {
                    this.subprojects.addElement(new ProjectInfo((Element)list.get(i)));
                }
            }
        }
    }

    public void addSubProjectInfo(ProjectInfo info) {
        if (this.infoType == 1) {
            this.subprojects.addElement(info);
        }
    }

    public void removeSubProjectInfo(ProjectInfo info) {
        if (this.infoType == 1) {
            this.subprojects.remove(info);
        }
    }

    public String getProjectDirectory() {
        return this.projdir;
    }

    public int getInfoType() {
        return this.infoType;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getProjectName() {
        return this.name;
    }

    public Vector getSubProjects() {
        return this.subprojects;
    }

    public String getDate() {
        return this.date;
    }

    public void setFileInfoParser(FileInfoParser parser) {
        this.parser = parser;
    }

    public FileInfoParser getFileInfoParser() {
        return this.parser;
    }

    public void setParent(ProjectBrowser parent) {
        this.parent = parent;
    }

    public ProjectBrowser getParent() {
        return this.parent;
    }

    public void setProjectPropertyDocument(Document doc) {
        this.doc = doc;
    }

    public Document getProjectPropertyDocument() {
        return this.doc;
    }

    public void setInputInterface(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
    }

    public void setInputDataManager(DataManager dm) {
        this.dm = dm;
    }

    public InputInterface getInputInterface() {
        return this.inputInterface;
    }

    public DataManager getInputDataManager() {
        return this.dm;
    }

    public void setOutputInterface(OutputInterface outputInterface) {
        this.outputInterface = outputInterface;
        outputInterface.setProjectInfo(this);
    }

    public OutputInterface getOutputInterface() {
        return this.outputInterface;
    }

    public void saveProjectPropertyDocument() {
        String chaseXML = this.getProjectDirectory() + System.getProperty("file.separator") + "chase.xml";
        try {
            FileWriter writer = new FileWriter(chaseXML);
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            outputter.output(this.doc, (Writer)writer);
        }
        catch (IOException ioe) {
            logger.error((Object)("failed to save document: " + chaseXML));
            return;
        }
    }

    public String toString() {
        String ls = System.getProperty("line.separator");
        String retValue = "project info: " + ls;
        if (this.infoType == 1) {
            retValue = retValue + " project info type: base" + ls;
        } else if (this.infoType == 2) {
            retValue = retValue + " project info type: sub" + ls;
        }
        retValue = retValue + "name: " + this.name + " date: " + this.date + " type: " + this.projectType + " dir: " + this.projdir;
        return retValue;
    }
}

