/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.primitiveguis.tableforinputinterface;

import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.AtomList;
import jp.advancesoft.chase.inputinterface.InputInterfaceEntryChangeEvent;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import jp.advancesoft.chase.inputinterface.inputinterfacetable.InputInterfaceTableSpecManager;
import jp.advancesoft.chase.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import org.apache.log4j.Logger;

public class TableModelForAtomCoords
extends TableModelForInputInterface {
    private Logger logger = Logger.getLogger((String)TableModelForAtomCoords.class.getName());
    private InputInterfaceTableSpecManager manager;
    private AtomCoords coords;
    private AtomList list;
    private String[] identifiers;
    private boolean updateAtomCoords = true;
    private JTable parentTable;
    TableModelListener[] tlisteners;

    public TableModelForAtomCoords(AtomCoords coords, String[] inputSpecifications, InputInterfaceTableSpecManager manager, int[] mapSpecCol, EventListener el, JTable parentTable) {
        super(inputSpecifications, manager, mapSpecCol, el);
        this.coords = coords;
        this.manager = manager;
        this.list = coords.getAtomList();
        this.parentTable = parentTable;
        this.initThis();
    }

    private void initThis() {
        this.createTableColumns();
        this.extractInputFile();
        this.setInputToModel();
    }

    protected void createTableColumns() {
        int i;
        if (this.columns == null) {
            return;
        }
        for (i = 0; i < this.mapSpecCol.length; ++i) {
            this.addColumn(this.columns[this.mapSpecCol[i]].getName());
        }
        this.identifiers = new String[this.getColumnCount()];
        for (i = 0; i < this.identifiers.length; ++i) {
            this.identifiers[i] = this.getColumnName(i);
        }
        int nrw = this.manager.getTableSpec(this.inputSpecifications[0]).getNumRows();
        if (nrw > 0) {
            this.setRowCount(nrw);
        }
        super.addTableModelListener((TableModelListener)this.el);
    }

    protected void extractInputFile() {
    }

    protected void setInputToModel() {
        if (this.list == null) {
            return;
        }
        this.removeListeners();
        this.updateAtomCoords = false;
        for (int i = 0; i < this.list.size(); ++i) {
            int j;
            Atom atom = this.list.getAtomAt(i);
            for (j = 0; j < this.getColumnCount(); ++j) {
                String val = AtomCoords.getValueFrom(atom, this.identifiers[j]);
                this.setValueAt(val, i, j);
            }
            for (j = 0; j < this.mapSpecCol.length; ++j) {
                if (!this.columns[this.mapSpecCol[j]].getDefaultValue().trim().equals("INCRE") || !this.columns[this.mapSpecCol[j]].ignoreOnSave()) continue;
                this.setValueAt(new Integer(i + 1), i, j);
            }
        }
        this.restoreListeners();
        this.setValueAt(this.getValueAt(0, 0), 0, 0);
        this.updateAtomCoords = true;
    }

    private void removeListeners() {
        this.tlisteners = this.getTableModelListeners();
        if (this.tlisteners != null) {
            for (int i = 0; i < this.tlisteners.length; ++i) {
                this.removeTableModelListener(this.tlisteners[i]);
            }
        }
    }

    private void restoreListeners() {
        if (this.tlisteners != null) {
            for (int i = 0; i < this.tlisteners.length; ++i) {
                this.addTableModelListener(this.tlisteners[i]);
            }
        }
    }

    public void setUpdateAtomCoords(boolean updateAtomCoords) {
        this.updateAtomCoords = updateAtomCoords;
    }

    public void execute(EventObject e) {
        TableModelListener[] listeners = this.getTableModelListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.removeTableModelListener(listeners[i]);
        }
        TableModelEvent tmde = (TableModelEvent)e;
        int first = 0;
        int last = 0;
        if (tmde == null) {
            this.restoreListeners(listeners);
            return;
        }
        first = tmde.getFirstRow();
        last = tmde.getLastRow();
        if (first < 0 || last < 0) {
            this.restoreListeners(listeners);
            return;
        }
        if (last >= this.getRowCount()) {
            this.restoreListeners(listeners);
            return;
        }
        for (int i = 0; i < this.mapSpecCol.length; ++i) {
            if (!this.columns[this.mapSpecCol[i]].getDefaultValue().trim().equals("INCRE") || !this.columns[this.mapSpecCol[i]].ignoreOnSave()) continue;
            this.setValueAt(new Integer(last + 1), last, i);
        }
        if (this.updateAtomCoords) {
            this.updateAtomCoords(first, last);
        }
        this.restoreListeners(listeners);
    }

    private void updateAtomCoords(int first, int last) {
        boolean nullCount = false;
        Vector<String> id = new Vector<String>();
        for (int i = 0; i < this.mapSpecCol.length; ++i) {
            if (this.columns[this.mapSpecCol[i]].ignoreOnSave()) continue;
            id.addElement(this.columns[this.mapSpecCol[i]].getName());
        }
        if (id == null) {
            return;
        }
        Object[] sid = new String[id.size()];
        id.copyInto(sid);
        for (int i = first; i < last + 1; ++i) {
            Vector<String> data = new Vector<String>();
            for (int j = 0; j < this.mapSpecCol.length; ++j) {
                InputInterfaceTableColumns col = this.columns[this.mapSpecCol[j]];
                if (col.ignoreOnSave()) continue;
                Object obj = this.getValueAt(i, j);
                String string = "";
                if (obj instanceof String) {
                    string = (String)obj;
                    if (string == null) {
                        string = "";
                    }
                } else if (obj instanceof Boolean) {
                    boolean bool = (Boolean)obj;
                    string = bool ? "1" : "0";
                }
                data.addElement(string);
            }
            if (data == null) continue;
            Object[] sdata = new String[data.size()];
            data.copyInto(sdata);
            Atom atom = AtomCoords.createAtomFrom((String[])sid, (String[])sdata);
            if (i >= this.list.size()) {
                this.list.addAtom(atom);
            } else if (i >= 0 && i < this.list.size()) {
                this.list.replaceAtomAt(i, atom);
            }
            this.logger.debug((Object)this.list);
        }
    }

    public void removeRow(int row) {
        this.logger.debug((Object)"removing row.");
        if (row < this.list.size() && row >= 0) {
            this.list.removeAtomAt(row);
        }
        super.removeRow(row);
    }

    public void setValueAt(Object data, int row, int col) {
        if (col >= this.mapSpecCol.length) {
            super.setValueAt(data, row, col);
            return;
        }
        if (!this.columns[this.mapSpecCol[col]].format()) {
            super.setValueAt(data, row, col);
        } else {
            Object formatedData;
            DecimalFormat formatter = this.columns[this.mapSpecCol[col]].getFormatter();
            if (data instanceof Double) {
                formatedData = formatter.format((Double)data);
            } else if (data instanceof String) {
                try {
                    Double d = Double.valueOf((String)data);
                    formatedData = formatter.format(d);
                }
                catch (NumberFormatException ne) {
                    formatedData = data;
                }
            } else {
                formatedData = data;
            }
            super.setValueAt(formatedData, row, col);
        }
    }

    public void inputInterfaceInitializing() {
    }

    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
    }
}

