/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.util.EventObject;
import javax.swing.JTextField;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.inputinterface.InputInterface;
import jp.advancesoft.chase.inputinterface.InputInterfaceBlock;
import jp.advancesoft.chase.inputinterface.InputInterfacePrimitiveEntry;
import org.apache.log4j.Logger;

class TextFieldPhase
extends JTextField
implements Command {
    private static Logger logger = Logger.getLogger((String)TextFieldPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;

    public TextFieldPhase(int columns) {
        super(columns);
    }

    public TextFieldPhase(int columns, String[] inputSpecifications, InputInterface inputinterface) {
        super(columns);
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
    }

    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        String inp = this.inputSpecifications[0];
        logger.debug((Object)("inp: " + inp));
        String[] fullName = inp.split("\\.");
        for (int i = 0; i < fullName.length - 1; ++i) {
            String ident = fullName[i].trim();
            if (this.inputinterface.selectBlock(ident)) continue;
            logger.debug((Object)("creating block: " + ident));
            this.inputinterface.addBlock(new InputInterfaceBlock(ident));
        }
        InputInterfacePrimitiveEntry entry = this.inputinterface.getPrimitiveEntry(fullName[fullName.length - 1]);
        entry.setName(fullName[fullName.length - 1]);
        String value = super.getText().trim();
        entry.setValue(value);
        if (value.length() == 0) {
            this.inputinterface.removeEntry(entry);
        } else {
            this.inputinterface.replaceEntry(entry);
        }
        this.inputinterface.selectRoot();
    }
}

