/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.graph.plotattributes;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import jp.advancesoft.chase.common.XMLUtils;
import jp.advancesoft.chase.graph.GraphPanel;
import jp.advancesoft.chase.graph.dataset.PlotProperties;
import jp.advancesoft.chase.graph.plotattributes.PlotAttributesSubEditor;
import jp.advancesoft.chase.main.PluginLoader;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;

public class PlotAttributesEditor
extends InternalFrameChase {
    private static Logger logger = Logger.getLogger((String)PlotAttributesEditor.class.getName());
    private Vector editors = new Vector();
    private GraphPanel parent;
    private JTabbedPane tabbedPane;
    private static final String xmlpath = "/jp/advancesoft/chase/graph/plotattributes/Editors.xml";
    private JComboBox plotSelector;

    public PlotAttributesEditor(GraphPanel parent) {
        super("edit plot attributes", true, true, true, true, new Dimension(512, 512));
        this.parent = parent;
        this.init();
    }

    public PlotAttributesSubEditor[] getPlotAttributesSubEditor(PlotAttributesEditor parent) {
        URL url = PlotAttributesEditor.class.getResource(xmlpath);
        Document doc = XMLUtils.getDocumentFrom(url);
        Element root = doc.getRootElement();
        List list = root.getChildren("editor");
        PluginLoader loader = new PluginLoader();
        PlotAttributesSubEditor[] editors = new PlotAttributesSubEditor[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Element editor = (Element)list.get(i);
            String name = editor.getChildTextTrim("name");
            String loadclass = editor.getChildTextTrim("loadclass");
            try {
                Class<?> cla = loader.loadClass(loadclass);
                Constructor<?>[] constructor = cla.getDeclaredConstructors();
                editors[i] = (PlotAttributesSubEditor)constructor[0].newInstance(parent);
                editors[i].setAttributeName(name);
                continue;
            }
            catch (Exception exc) {
                logger.error((Object)("failed to load: " + loadclass));
                exc.printStackTrace();
                return null;
            }
        }
        return editors;
    }

    public Plot getSelectedPlot() {
        int index = this.plotSelector.getSelectedIndex();
        Plot plot = this.parent.getChart().getPlot();
        Plot ret = null;
        if (plot instanceof CombinedRangeXYPlot) {
            logger.debug((Object)"combined range xyplot...");
            List list = ((CombinedRangeXYPlot)plot).getSubplots();
            if (list != null) {
                ret = (Plot)list.get(index);
            }
        } else if (plot instanceof CombinedDomainXYPlot) {
            logger.debug((Object)"combined domain xyplot...");
            List list = ((CombinedDomainXYPlot)plot).getSubplots();
            if (list != null) {
                ret = (Plot)list.get(index);
            }
        } else {
            logger.debug((Object)"generic plot...");
            ret = plot;
        }
        return ret;
    }

    private void choosePlot() {
        Plot plot = this.getSelectedPlot();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            PlotAttributesSubEditor sub = (PlotAttributesSubEditor)this.tabbedPane.getComponentAt(i);
            sub.plotChanged(plot);
        }
    }

    private void init() {
        PlotProperties props = this.parent.getPlotProperties();
        System.out.println("parent: " + this.parent + " editor: " + this.parent.getEditor());
        int count = props.getSubPlotCount();
        String[] plots = new String[count];
        for (int i = 0; i < count; ++i) {
            plots[i] = props.getSubPlotPropertiesAt(i).getDataSetCollection().getName();
        }
        this.plotSelector = new JComboBox<String>(plots);
        this.plotSelector.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotAttributesEditor.this.choosePlot();
            }
        });
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane();
        JPanel contents = new JPanel();
        contents.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        PlotAttributesSubEditor[] editors = this.getPlotAttributesSubEditor(this);
        for (int i = 0; i < editors.length; ++i) {
            editors[i].init();
            editors[i].initGUI();
            this.tabbedPane.addTab(editors[i].getAttributeName(), editors[i]);
        }
        contents.add((Component)this.tabbedPane, constraints);
        constraints.weighty = 1.0;
        contents.add(new JPanel());
        constraints.weighty = 0.0;
        JPanel btnpanel = new JPanel();
        JButton btnupdate = new JButton("update");
        JButton btnclose = new JButton("close");
        JPanel pselector = new JPanel();
        pselector.setBorder(new TitledBorder("select plot"));
        pselector.add(this.plotSelector);
        btnpanel.add(pselector);
        btnpanel.add(btnupdate);
        btnpanel.add(btnclose);
        constraints.gridy = 2;
        constraints.anchor = 10;
        contents.add((Component)btnpanel, constraints);
        btnclose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotAttributesEditor.this.dispose();
            }
        });
        btnupdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PlotAttributesEditor.this.doUpdate();
            }
        });
        this.add((Component)contents, "North");
    }

    public GraphPanel getGraphPanel() {
        return this.parent;
    }

    private void doUpdate() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            PlotAttributesSubEditor sub = (PlotAttributesSubEditor)this.tabbedPane.getComponentAt(i);
            if (sub.updateChart()) continue;
            logger.error((Object)("update from " + sub.getAttributeName() + " panel failed."));
        }
    }
}

