/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.atomcoord;

import org.apache.log4j.Logger;

public class Cell {
    private static Logger logger = Logger.getLogger((String)Cell.class.getName());
    public static final int CELL_VEC = 0;
    public static final int CELL_ABC = 1;
    private int cellScheme = 0;
    private String[][] cell;

    public Cell(String[][] cell, int cellScheme) {
        this.cell = cell;
        this.cellScheme = cellScheme;
    }

    public Cell(String a, String b, String c, String alpha, String beta, String gamma) {
        this.cellScheme = 1;
        this.cell = new String[2][3];
        this.cell[0][0] = a;
        this.cell[0][1] = b;
        this.cell[0][2] = c;
        this.cell[1][0] = alpha;
        this.cell[1][1] = beta;
        this.cell[1][2] = gamma;
    }

    public Cell(String[] a, String[] b, String[] c) {
        this.cellScheme = 0;
        this.cell = new String[3][3];
        this.cell[0] = a;
        this.cell[1] = b;
        this.cell[2] = c;
    }

    public Cell(double a, double b, double c, double alpha, double beta, double gamma) {
        this.cellScheme = 1;
        this.cell = new String[2][3];
        this.cell[0][0] = Double.toString(a);
        this.cell[0][1] = Double.toString(b);
        this.cell[0][2] = Double.toString(c);
        this.cell[1][0] = Double.toString(alpha);
        this.cell[1][1] = Double.toString(beta);
        this.cell[1][2] = Double.toString(gamma);
    }

    public Cell(double[] a, double[] b, double[] c) {
        this.cellScheme = 0;
        this.cell = new String[3][3];
        for (int i = 0; i < 3; ++i) {
            this.cell[0][i] = Double.toString(a[i]);
            this.cell[1][i] = Double.toString(b[i]);
            this.cell[2][i] = Double.toString(c[i]);
        }
    }

    public Cell getCopy() {
        return new Cell(this.cell, this.cellScheme);
    }

    public int getCellScheme() {
        return this.cellScheme;
    }

    public String[][] getCell() {
        return this.cell;
    }

    public double[][] getDouble() {
        int irow = 3;
        if (this.cellScheme == 1) {
            irow = 2;
        }
        double[][] ret = new double[irow][3];
        for (int i = 0; i < irow; ++i) {
            for (int j = 0; j < 3; ++j) {
                try {
                    ret[i][j] = Double.parseDouble(this.cell[i][j]);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    logger.warn((Object)"failed to get a 'double' representation of cell");
                    return null;
                }
            }
        }
        return ret;
    }
}

