/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.phase;

import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import jp.advancesoft.chase.atomcoord.Importers;
import jp.advancesoft.chase.common.AtomConfigFilter;
import jp.advancesoft.chase.common.Command;
import jp.advancesoft.chase.common.HasPost;
import org.apache.log4j.Logger;

class ImportButton
extends JButton
implements Command {
    private static Logger logger = Logger.getLogger((String)ImportButton.class.getName());
    private Importers importers;
    private TableModel model;
    private TableModel[] modelCell;
    private JTable table;
    private JTable[] cellTable;
    private JComboBox unit;

    public ImportButton(String title, JTable table, TableModel model, JTable[] cellTable, TableModel[] modelCell, Importers importers, EventListener listener) {
        super(title);
        this.table = table;
        this.cellTable = cellTable;
        this.model = model;
        this.modelCell = modelCell;
        this.importers = importers;
        super.addActionListener((ActionListener)listener);
    }

    public ImportButton(String title, JTable table, TableModel model, JTable[] cellTable, TableModel[] modelCell, Importers importers, JComboBox unit, EventListener listener) {
        super(title);
        this.table = table;
        this.cellTable = cellTable;
        this.model = model;
        this.modelCell = modelCell;
        this.importers = importers;
        this.unit = unit;
        super.addActionListener((ActionListener)listener);
    }

    public void execute(EventObject e) {
        JFileChooser fdlg = new JFileChooser(".");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("select atomic configuration file");
        fdlg.setFileSelectionMode(0);
        fdlg.addChoosableFileFilter(new AtomConfigFilter());
        if (fdlg.showOpenDialog(this) != 0) {
            return;
        }
        File file = fdlg.getSelectedFile();
        if (!this.importers.importAtomicCoordinatesFrom(file)) {
            logger.warn((Object)("failed import from: " + file));
        } else {
            int i;
            ((HasPost)((Object)this.model)).disablePost();
            for (i = 0; i < this.modelCell.length; ++i) {
                ((HasPost)((Object)this.modelCell[i])).disablePost();
            }
            this.importers.updateTable(this.model, this.modelCell);
            for (i = 0; i < this.cellTable.length; ++i) {
                if (this.cellTable[i] == null) continue;
                this.cellTable[i].update(this.cellTable[i].getGraphics());
            }
            ((HasPost)((Object)this.model)).enablePost();
            for (i = 0; i < this.modelCell.length; ++i) {
                ((HasPost)((Object)this.modelCell[i])).enablePost();
            }
            logger.info((Object)("import from " + file + " complete"));
            if (this.unit != null && file.getName().toLowerCase().endsWith("cif")) {
                this.unit.setSelectedIndex(2);
            }
        }
        if (this.table != null) {
            this.table.update(this.table.getGraphics());
        }
    }
}

