/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.mainpanel;

import com.jcraft.jsch.Session;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import jp.advancesoft.chase.common.ConstParameters;
import jp.advancesoft.chase.common.MyThread;
import jp.advancesoft.chase.process.ProcessViewer;
import jp.advancesoft.chase.settings.GlobalProperties;
import jp.advancesoft.chase.settings.PropertiesManager;
import jp.advancesoft.chase.ssh.Execute;
import jp.advancesoft.chase.ssh.SessionCreator;
import jp.advancesoft.chase.ssh.hosts.HostInfo;
import jp.advancesoft.chase.ssh.hosts.MyUserInfo;
import org.apache.log4j.Logger;

class ProcessMenuItemListener
implements ActionListener {
    private static Logger logger = Logger.getLogger((String)ProcessMenuItemListener.class.getName());
    private HostInfo hostinfo;

    protected ProcessMenuItemListener(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
    }

    public void actionPerformed(ActionEvent e) {
        this.doIt();
    }

    private void doIt() {
        MyUserInfo userinfo = new MyUserInfo(this.hostinfo);
        String user = this.hostinfo.getProperty("username");
        String hostname = this.hostinfo.getProperty("address");
        if (hostname.trim().equals("127.0.0.1") || hostname.trim().equals("localhost")) {
            if (ConstParameters.osName.toLowerCase().trim().startsWith("windows")) {
                GlobalProperties propChase = PropertiesManager.getGlobalProperties(0);
                String taskmgr = propChase.getProperty("taskmgr");
                MyThread th = new MyThread(taskmgr);
                return;
            }
            ProcessViewer psv = new ProcessViewer();
            psv.start();
            return;
        }
        try {
            Session session = SessionCreator.getSession(this.hostinfo);
            Execute exe = new Execute(session);
            ProcessViewer psv = new ProcessViewer(exe, user);
            psv.start();
        }
        catch (Exception exc) {
            logger.error((Object)"failed connection");
            exc.printStackTrace();
        }
    }
}

