/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.imageviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jp.advancesoft.chase.common.ChaseFileChooser;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.Utils;
import jp.advancesoft.chase.imageviewer.MainPanel;
import jp.advancesoft.chase.settings.PropertiesManager;
import org.apache.log4j.Logger;

public class ImageLoaderPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)ImageLoaderPanel.class.getName());
    private String dir;
    private Vector imagefiles_wk;
    private String[] imagefiles;
    private String[] imagefiles_selected;
    private JTextArea labeldir;
    private File file;
    private JButton btndir;
    private JButton btnshow;
    private JButton btnclose;
    private JPanel plist;
    private JPanel pbtn;
    private JList list;
    private JScrollPane scrpane;
    private final String DEFAULT_RESOLUTION = "100";
    private JTextField ipres;
    private int pageNum = 0;
    private int page = 0;

    public ImageLoaderPanel(String dir) {
        this.dir = dir;
        this.file = new File(dir);
        this.init();
    }

    private void init() {
        ImageLoaderPanel p = this;
        this.setImageFiles();
        p.setLayout(new BoxLayout(p, 1));
        JPanel textPanel = new JPanel();
        textPanel.setLayout(new BorderLayout());
        this.ipres = new JTextField(12);
        this.ipres.setText("100");
        textPanel.add((Component)new JLabel("resolution(ps,eps,pdf): "), "West");
        textPanel.add((Component)this.ipres, "Center");
        JPanel panel2 = new JPanel();
        panel2.add(textPanel);
        this.file = new File(this.dir);
        JLabel labeldir = new JLabel("current directory: " + this.file.toString());
        labeldir.setBackground(Color.cyan);
        labeldir.setForeground(Color.blue);
        p.add(labeldir);
        this.list = new JList<String>(this.imagefiles);
        Font font = new Font("Serif", 0, 14);
        this.list.setFont(font);
        this.scrpane = new JScrollPane(this.list);
        p.add(this.scrpane);
        JButton btndir = new JButton("select directory");
        JButton btnshow = new JButton("show selected image(s)");
        this.pbtn = new JPanel();
        this.pbtn.setLayout(new BoxLayout(this.pbtn, 0));
        this.pbtn.add((Component)panel2, "West");
        this.pbtn.add((Component)btndir, "Center");
        this.pbtn.add((Component)btnshow, "East");
        p.add(this.pbtn);
        btnshow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageLoaderPanel.this.bootImageViewer();
            }
        });
        btndir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageLoaderPanel.this.selectDir();
                ImageLoaderPanel.this.redraw();
            }
        });
    }

    private void bootImageViewer() {
        if (this.list.getSelectedValues().length > 0) {
            this.imagefiles_selected = new String[this.list.getSelectedValues().length];
            for (int i = 0; i < this.list.getSelectedValues().length; ++i) {
                this.imagefiles_selected[i] = this.list.getSelectedValues()[i].toString();
                try {
                    if (!this.dir.endsWith(File.separator)) {
                        this.dir = this.dir + File.separator;
                    }
                    String infileName = this.dir + this.imagefiles_selected[i];
                    String[] pageArray = null;
                    String originalName = infileName;
                    if (infileName.toLowerCase().trim().endsWith(".eps") || infileName.toLowerCase().trim().endsWith(".ps") || infileName.toLowerCase().trim().endsWith(".pdf")) {
                        pageArray = this.getTemporaryImageFile(infileName);
                        if (pageArray != null && pageArray.length != 0) {
                            infileName = pageArray[0];
                        } else {
                            this.logger.error((Object)"invalid ps/eps/pdf file");
                            return;
                        }
                    }
                    if (!new File(infileName).exists()) {
                        this.logger.error((Object)"file does not exist!");
                        return;
                    }
                    MainPanel mp = new MainPanel(infileName, originalName);
                    if (!mp.getStatus()) continue;
                    mp.setPageNum(this.pageNum);
                    this.pageNum = 0;
                    if (pageArray != null) {
                        mp.setPageArray(pageArray);
                    }
                    mp.display();
                    mp.requestFocus();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error((Object)"failed to boot image viewer");
                }
            }
        } else {
            this.logger.error((Object)"select image file from list");
        }
    }

    private void setImageFiles() {
        if (this.file.isDirectory()) {
            int i;
            this.imagefiles_wk = new Vector();
            for (i = 0; i < this.file.list().length; ++i) {
                String name = this.file.list()[i];
                if (!name.toLowerCase().endsWith(".jpg") && !name.toLowerCase().endsWith(".jpeg") && !name.toLowerCase().endsWith(".png") && !name.toLowerCase().endsWith(".eps") && !name.toLowerCase().endsWith(".ps") && !name.toLowerCase().endsWith(".pdf") && !name.toLowerCase().endsWith(".gif") && !name.toLowerCase().endsWith(".tif") && !name.toLowerCase().endsWith(".tiff") && !name.toLowerCase().endsWith(".bmp")) continue;
                this.imagefiles_wk.addElement(name);
            }
            this.imagefiles = new String[this.imagefiles_wk.size()];
            for (i = 0; i < this.imagefiles_wk.size(); ++i) {
                this.imagefiles[i] = (String)this.imagefiles_wk.get(i);
            }
        } else {
            this.imagefiles = new String[1];
            this.imagefiles[0] = "";
        }
    }

    private void selectDir() {
        ChaseFileChooser fdlg = new ChaseFileChooser("media");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("Open");
        fdlg.setFileSelectionMode(1);
        if (fdlg.showDialog(this, "open") != 0) {
            return;
        }
        this.dir = fdlg.getSelectedFile().getAbsolutePath();
        this.file = new File(this.dir);
    }

    private void redraw() {
        this.removeAll();
        this.init();
        this.revalidate();
    }

    public String[] getTemporaryImageFile(String infileName) {
        String FS = System.getProperty("file.separator");
        File infileFile = new File(infileName);
        String fileName = infileFile.getName();
        String tmpDir = System.getProperty("user.home") + FS + ".chase";
        String imageFile = tmpDir + FS + fileName;
        String imageFileIn = Utils.getPathDQ(imageFile + "%d.png");
        infileName = Utils.getPathDQ(infileName);
        int ires = 60;
        String res = new String();
        try {
            res = this.ipres.getText();
        }
        catch (Exception ex) {
            res = "100";
            this.logger.info((Object)"using default resolution...");
        }
        try {
            ires = Integer.parseInt(res.trim());
        }
        catch (NumberFormatException ne) {
            this.logger.info((Object)"using default resolution");
            ires = 60;
        }
        String epsCrop = "";
        if (fileName.trim().toLowerCase().endsWith(".eps")) {
            epsCrop = "-dEPSCrop";
        }
        String gs = PropertiesManager.getGlobalProperties(0).getProperty("gs");
        String gsExe = Utils.getPathDQ(gs) + " -q -dNOPROMPT -dBATCH -sDEVICE=png16m -r" + ires + " " + epsCrop + " -dNOPAUSE -sOutputFile=" + imageFileIn + " " + infileName;
        this.logger.info((Object)("gsexe: " + gsExe));
        BufferedReader[] br = new BufferedReader[2];
        try {
            br = ExternalProgramExecuter.executeGetBR(gsExe, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"failed to run gs.");
        }
        while (true) {
            ++this.pageNum;
            File pageFile = new File(imageFile + this.pageNum + ".png");
            if (!pageFile.exists()) break;
            pageFile.deleteOnExit();
        }
        --this.pageNum;
        this.logger.info((Object)("number of pages: " + this.pageNum));
        String[] tmpImageFiles = new String[this.pageNum];
        for (int i = 0; i < this.pageNum; ++i) {
            int ii = i + 1;
            tmpImageFiles[i] = imageFile + ii + ".png";
        }
        return tmpImageFiles;
    }
}

