/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.sense8;

import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.parser.sense8.NFFParserConstants;
import org.cybergarage.x3d.parser.sense8.NFFParserTokenManager;
import org.cybergarage.x3d.parser.sense8.ParseException;
import org.cybergarage.x3d.parser.sense8.SimpleCharStream;
import org.cybergarage.x3d.parser.sense8.Token;
import org.cybergarage.x3d.util.Debug;

public class NFFParser
implements NFFParserConstants {
    private ShapeNode mShapeNode;
    private IndexedFaceSetNode mIdxFaceSetNode;
    public NFFParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[10];
    private final int[] jj_la1_0 = new int[]{135266784, 135266784, 512, 0x200000, 15360, 15360, 262144, 117686272, 117686272, 262144};
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public NFFParser() {
    }

    public void initialize() {
        this.mShapeNode = new ShapeNode();
        this.mIdxFaceSetNode = new IndexedFaceSetNode();
        this.mIdxFaceSetNode.setColorPerVertex(false);
        this.mIdxFaceSetNode.setNormalPerVertex(true);
        this.mShapeNode.addChildNode(this.mIdxFaceSetNode);
        this.mIdxFaceSetNode.addChildNode(new CoordinateNode());
        this.mIdxFaceSetNode.addChildNode(new ColorNode());
    }

    public ShapeNode getShapeNode() {
        return this.mShapeNode;
    }

    public IndexedFaceSetNode getIndexedFaceSetNode() {
        return this.mIdxFaceSetNode;
    }

    private CoordinateNode getCoordinateNode() {
        return this.getIndexedFaceSetNode().getCoordinateNodes();
    }

    private NormalNode getNormalNode() {
        return this.getIndexedFaceSetNode().getNormalNodes();
    }

    private ColorNode getColorNode() {
        return this.getIndexedFaceSetNode().getColorNodes();
    }

    private void addCoordinate(float x, float y, float z) {
        this.getCoordinateNode().addPoint(x, y, z);
    }

    private void addNormal(float x, float y, float z) {
        this.getNormalNode().addVector(x, y, z);
    }

    private void addColor(float[] color) {
        this.getColorNode().addColor(color);
    }

    private void addCoordIndex(int index) {
        this.getIndexedFaceSetNode().addCoordIndex(index);
    }

    public int getNCoordIndices() {
        return this.getIndexedFaceSetNode().getNCoordIndices();
    }

    public int getCoordIndex(int n) {
        return this.getIndexedFaceSetNode().getCoordIndex(n);
    }

    private void addNormalIndex(int index) {
        this.getIndexedFaceSetNode().addNormalIndex(index);
    }

    public int getNNormalIndices() {
        return this.getIndexedFaceSetNode().getNNormalIndices();
    }

    public int getNormalIndex(int n) {
        return this.getIndexedFaceSetNode().getNormalIndex(n);
    }

    private void addTexCoordIndex(int index) {
        this.getIndexedFaceSetNode().addTexCoordIndex(index);
    }

    public int getNTexCoordIndices() {
        return this.getIndexedFaceSetNode().getNTexCoordIndices();
    }

    public int getTexCoordIndex(int n) {
        return this.getIndexedFaceSetNode().getTexCoordIndex(n);
    }

    public final int IndexToken() throws ParseException {
        Token t = this.jj_consume_token(18);
        return Integer.parseInt(t.image);
    }

    public final int NumberToken() throws ParseException {
        Token t = this.jj_consume_token(19);
        return Integer.parseInt(t.image);
    }

    public final float FloatToken() throws ParseException {
        Token t = this.jj_consume_token(21);
        Float floatObj = new Float(t.image);
        return floatObj.floatValue();
    }

    public final float[] ColorToken() throws ParseException {
        Token t = this.jj_consume_token(23);
        String colorString = t.image.substring(2);
        int colorValue = Integer.parseInt(colorString, 16);
        Debug.message("color = 0x" + Integer.toHexString(colorValue));
        float[] color = new float[3];
        if (colorString.length() == 3) {
            color[0] = (float)((colorValue & 0xF00) >> 8) / 127.0f;
            color[1] = (float)((colorValue & 0xF0) >> 4) / 127.0f;
            color[2] = (float)((colorValue & 0xF) >> 0) / 127.0f;
        } else {
            color[0] = (float)((colorValue & 0xFF0000) >> 16) / 255.0f;
            color[1] = (float)((colorValue & 0xFF00) >> 8) / 255.0f;
            color[2] = (float)((colorValue & 0xFF) >> 0) / 255.0f;
        }
        return color;
    }

    public final String NameToken() throws ParseException {
        Token t = this.jj_consume_token(20);
        return t.image;
    }

    public final void NFF() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 20: 
                case 27: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            this.NFFElement();
        }
    }

    public final void NFFElement() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.Header();
                break;
            }
            case 6: {
                this.Version();
                break;
            }
            case 7: {
                this.Viewpos();
                break;
            }
            case 8: {
                this.Viewdir();
                break;
            }
            case 20: {
                this.Object();
                break;
            }
            case 27: {
                this.jj_consume_token(27);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Header() throws ParseException {
        this.jj_consume_token(5);
        this.jj_consume_token(27);
    }

    public final void Version() throws ParseException {
        this.jj_consume_token(6);
        float ver = this.FloatToken();
        this.jj_consume_token(27);
    }

    public final void Viewpos() throws ParseException {
        this.jj_consume_token(7);
        float x = this.FloatToken();
        float y = this.FloatToken();
        float z = this.FloatToken();
        this.jj_consume_token(27);
    }

    public final void Viewdir() throws ParseException {
        this.jj_consume_token(8);
        float x = this.FloatToken();
        float y = this.FloatToken();
        float z = this.FloatToken();
        this.jj_consume_token(27);
    }

    public final void Object() throws ParseException {
        this.ObjectName();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.MaterialName();
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
            }
        }
        this.DefVertex();
        this.DefPoly();
    }

    public final void ObjectName() throws ParseException {
        String objName = this.NameToken();
        this.jj_consume_token(27);
        this.getShapeNode().setName(objName);
        Debug.message("NAME = " + objName);
    }

    public final void MaterialName() throws ParseException {
        this.jj_consume_token(9);
        String matName = this.NameToken();
        this.jj_consume_token(27);
    }

    public final void DefVertex() throws ParseException {
        this.NVertices();
        block3: while (true) {
            this.Vertex();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[3] = this.jj_gen;
    }

    public final void NVertices() throws ParseException {
        int nVertices = this.IndexToken();
        this.jj_consume_token(27);
        Debug.message("number of vertices = " + nVertices);
    }

    public final void Vertex() throws ParseException {
        block10: {
            this.VertexPos();
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        this.jj_la1[4] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 11: {
                        this.VertexNormal();
                        continue block9;
                    }
                    case 10: {
                        this.jj_consume_token(10);
                        continue block9;
                    }
                    case 12: {
                        this.VertexColor();
                        continue block9;
                    }
                    case 13: {
                        this.VertexTexCoord();
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[5] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(27);
    }

    public final void VertexPos() throws ParseException {
        float vx = this.FloatToken();
        float vy = this.FloatToken();
        float vz = this.FloatToken();
        this.addCoordinate(vx, vy, vz);
        Debug.message(String.valueOf(vx) + ", " + vy + ", " + vz);
    }

    public final void VertexNormal() throws ParseException {
        this.jj_consume_token(11);
        float nx = this.FloatToken();
        float ny = this.FloatToken();
        float nz = this.FloatToken();
    }

    public final void VertexColor() throws ParseException {
        this.jj_consume_token(12);
        float[] color = this.ColorToken();
    }

    public final void VertexTexCoord() throws ParseException {
        this.jj_consume_token(13);
        float u = this.FloatToken();
        float v = this.FloatToken();
    }

    public final void DefPoly() throws ParseException {
        this.NPolys();
        block3: while (true) {
            this.Poly();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[6] = this.jj_gen;
    }

    public final void NPolys() throws ParseException {
        int nPolys = this.IndexToken();
        this.jj_consume_token(27);
    }

    public final void Poly() throws ParseException {
        block13: {
            this.Shape();
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 24: 
                    case 25: 
                    case 26: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 14: {
                        this.jj_consume_token(14);
                        continue block12;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        continue block12;
                    }
                    case 15: {
                        this.Rot();
                        continue block12;
                    }
                    case 16: {
                        this.Scale();
                        continue block12;
                    }
                    case 17: {
                        this.Trans();
                        continue block12;
                    }
                    case 26: {
                        this.jj_consume_token(26);
                        continue block12;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[8] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(27);
    }

    public final void Shape() throws ParseException {
        int nIndices = this.IndexToken();
        block3: while (true) {
            this.ShapeIndex();
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[9] = this.jj_gen;
        float[] color = this.ColorToken();
        this.addColor(color);
        this.addCoordIndex(-1);
    }

    public final void ShapeIndex() throws ParseException {
        int index = this.IndexToken();
        this.addCoordIndex(index);
    }

    public final void Rot() throws ParseException {
        this.jj_consume_token(15);
        float angle = this.NumberToken();
    }

    public final void Scale() throws ParseException {
        this.jj_consume_token(16);
        float factor = this.NumberToken();
    }

    public final void Trans() throws ParseException {
        this.jj_consume_token(17);
        float x = this.NumberToken();
        float y = this.NumberToken();
    }

    public final void Input() throws ParseException {
        this.NFF();
        this.jj_consume_token(0);
    }

    public NFFParser(InputStream stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new NFFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 10) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 10) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public NFFParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new NFFParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 10) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 10) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public NFFParser(NFFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 10) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(NFFParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 10) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public final ParseException generateParseException() {
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[28];
        int i = 0;
        while (i < 28) {
            la1tokens[i] = false;
            ++i;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        i = 0;
        while (i < 10) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((this.jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 28) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.addElement(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

