/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFRotation;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;

public class ExtrusionNode
extends Geometry3DNode {
    private static final String beginCapFieldName = "beginCap";
    private static final String endCapFieldName = "endCap";
    private static final String convexFieldName = "convex";
    private static final String creaseAngleFieldName = "creaseAngle";
    private static final String orientationFieldName = "orientation";
    private static final String scaleFieldName = "scale";
    private static final String crossSectionFieldName = "crossSection";
    private static final String spineFieldName = "spine";
    private static final String ccwFieldName = "ccw";
    private static final String solidFieldName = "solid";
    private static final String crossSectionEventInName = "crossSection";
    private static final String orientationEventInName = "orientation";
    private static final String scaleEventInName = "scale";
    private static final String spineEventInName = "spine";
    private SFBool beginCapField;
    private SFBool endCapField;
    private SFBool convexField;
    private SFFloat creaseAngleField;
    private SFBool ccwField;
    private SFBool solidField;
    private MFRotation orientationField;
    private MFVec2f scaleField;
    private MFVec2f crossSectionField;
    private MFVec3f spineField;
    private MFRotation setOrientationField;
    private MFVec2f setScaleField;
    private MFVec2f setCrossSectionField;
    private MFVec3f setSpineField;

    public ExtrusionNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.EXTRUSION);
        this.beginCapField = new SFBool(true);
        this.addField(beginCapFieldName, this.beginCapField);
        this.endCapField = new SFBool(true);
        this.addField(endCapFieldName, this.endCapField);
        this.convexField = new SFBool(true);
        this.convexField.setName(convexFieldName);
        this.addField(this.convexField);
        this.creaseAngleField = new SFFloat(0.0f);
        this.creaseAngleField.setName(creaseAngleFieldName);
        this.addField(this.creaseAngleField);
        this.orientationField = new MFRotation();
        this.orientationField.setName("orientation");
        this.addField(this.orientationField);
        this.scaleField = new MFVec2f();
        this.scaleField.setName("scale");
        this.addField(this.scaleField);
        this.crossSectionField = new MFVec2f();
        this.addField("crossSection", this.crossSectionField);
        this.spineField = new MFVec3f();
        this.addField("spine", this.spineField);
        this.ccwField = new SFBool(true);
        this.ccwField.setName(ccwFieldName);
        this.addField(this.ccwField);
        this.solidField = new SFBool(true);
        this.solidField.setName(solidFieldName);
        this.addField(this.solidField);
        this.setOrientationField = new MFRotation();
        this.setOrientationField.setName("orientation");
        this.addEventIn(this.setOrientationField);
        this.setScaleField = new MFVec2f();
        this.setScaleField.setName("scale");
        this.addEventIn(this.setScaleField);
        this.setCrossSectionField = new MFVec2f();
        this.addEventIn("crossSection", this.setCrossSectionField);
        this.setSpineField = new MFVec3f();
        this.addEventIn("spine", this.setSpineField);
    }

    public ExtrusionNode(ExtrusionNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFBool getBeginCapField() {
        if (!this.isInstanceNode()) {
            return this.beginCapField;
        }
        return (SFBool)this.getField(beginCapFieldName);
    }

    public void setBeginCap(boolean value) {
        this.getBeginCapField().setValue(value);
    }

    public void setBeginCap(String value) {
        this.getBeginCapField().setValue(value);
    }

    public boolean getBeginCap() {
        return this.getBeginCapField().getValue();
    }

    public SFBool getEndCapField() {
        if (!this.isInstanceNode()) {
            return this.endCapField;
        }
        return (SFBool)this.getField(endCapFieldName);
    }

    public void setEndCap(boolean value) {
        this.getEndCapField().setValue(value);
    }

    public void setEndCap(String value) {
        this.getEndCapField().setValue(value);
    }

    public boolean getEndCap() {
        return this.getEndCapField().getValue();
    }

    public SFBool getConvexField() {
        if (!this.isInstanceNode()) {
            return this.convexField;
        }
        return (SFBool)this.getField(convexFieldName);
    }

    public void setConvex(boolean value) {
        this.getConvexField().setValue(value);
    }

    public void setConvex(String value) {
        this.getConvexField().setValue(value);
    }

    public boolean getConvex() {
        return this.getConvexField().getValue();
    }

    public SFBool getCCWField() {
        if (!this.isInstanceNode()) {
            return this.ccwField;
        }
        return (SFBool)this.getField(ccwFieldName);
    }

    public void setCCW(boolean value) {
        this.getCCWField().setValue(value);
    }

    public void setCCW(String value) {
        this.getCCWField().setValue(value);
    }

    public boolean getCCW() {
        return this.getCCWField().getValue();
    }

    public boolean isCCW() {
        return this.getCCW();
    }

    public SFBool getSolidField() {
        if (!this.isInstanceNode()) {
            return this.solidField;
        }
        return (SFBool)this.getField(solidFieldName);
    }

    public void setSolid(boolean value) {
        this.getSolidField().setValue(value);
    }

    public void setSolid(String value) {
        this.getSolidField().setValue(value);
    }

    public boolean getSolid() {
        return this.getSolidField().getValue();
    }

    public boolean isSolid() {
        return this.getSolid();
    }

    public SFFloat getCreaseAngleField() {
        if (!this.isInstanceNode()) {
            return this.creaseAngleField;
        }
        return (SFFloat)this.getField(creaseAngleFieldName);
    }

    public void setCreaseAngle(float value) {
        this.getCreaseAngleField().setValue(value);
    }

    public void setCreaseAngle(String value) {
        this.getCreaseAngleField().setValue(value);
    }

    public float getCreaseAngle() {
        return this.getCreaseAngleField().getValue();
    }

    public MFRotation getOrientationField() {
        if (!this.isInstanceNode()) {
            return this.orientationField;
        }
        return (MFRotation)this.getField("orientation");
    }

    public void addOrientation(float[] value) {
        this.getOrientationField().addValue(value);
    }

    public void addOrientation(float x, float y, float z, float angle) {
        this.getOrientationField().addValue(x, y, z, angle);
    }

    public int getNOrientations() {
        return this.getOrientationField().getSize();
    }

    public void setOrientation(int index, float[] value) {
        this.getOrientationField().set1Value(index, value);
    }

    public void setOrientation(int index, float x, float y, float z, float angle) {
        this.getOrientationField().set1Value(index, x, y, z, angle);
    }

    public void setOrientations(String value) {
        this.getOrientationField().setValues(value);
    }

    public void setOrientations(String[] value) {
        this.getOrientationField().setValues(value);
    }

    public void getOrientation(int index, float[] value) {
        this.getOrientationField().get1Value(index, value);
    }

    public float[] getOrientation(int index) {
        float[] value = new float[4];
        this.getOrientation(index, value);
        return value;
    }

    public void removeOrientation(int index) {
        this.getOrientationField().removeValue(index);
    }

    public MFVec2f getScaleField() {
        if (!this.isInstanceNode()) {
            return this.scaleField;
        }
        return (MFVec2f)this.getField("scale");
    }

    public void addScale(float[] value) {
        this.getScaleField().addValue(value);
    }

    public void addScale(float x, float y) {
        this.getScaleField().addValue(x, y);
    }

    public int getNScales() {
        return this.getScaleField().getSize();
    }

    public void setScale(int index, float[] value) {
        this.getScaleField().set1Value(index, value);
    }

    public void setScale(int index, float x, float y) {
        this.getScaleField().set1Value(index, x, y);
    }

    public void setScales(String value) {
        this.getScaleField().setValues(value);
    }

    public void setScales(String[] value) {
        this.getScaleField().setValues(value);
    }

    public void getScale(int index, float[] value) {
        this.getScaleField().get1Value(index, value);
    }

    public float[] getScale(int index) {
        float[] value = new float[2];
        this.getScale(index, value);
        return value;
    }

    public void removeScale(int index) {
        this.getScaleField().removeValue(index);
    }

    public MFVec2f getCrossSectionField() {
        if (!this.isInstanceNode()) {
            return this.crossSectionField;
        }
        return (MFVec2f)this.getField("crossSection");
    }

    public void addCrossSection(float[] value) {
        this.getCrossSectionField().addValue(value);
    }

    public void addCrossSection(float x, float y) {
        this.getCrossSectionField().addValue(x, y);
    }

    public int getNCrossSections() {
        return this.getCrossSectionField().getSize();
    }

    public void setCrossSection(int index, float[] value) {
        this.getCrossSectionField().set1Value(index, value);
    }

    public void setCrossSection(int index, float x, float y) {
        this.getCrossSectionField().set1Value(index, x, y);
    }

    public void setCrossSections(String value) {
        this.getCrossSectionField().setValues(value);
    }

    public void setCrossSections(String[] value) {
        this.getCrossSectionField().setValues(value);
    }

    public void getCrossSection(int index, float[] value) {
        this.getCrossSectionField().get1Value(index, value);
    }

    public float[] getCrossSection(int index) {
        float[] value = new float[2];
        this.getCrossSection(index, value);
        return value;
    }

    public void removeCrossSection(int index) {
        this.getCrossSectionField().removeValue(index);
    }

    public MFVec3f getSpineField() {
        if (!this.isInstanceNode()) {
            return this.spineField;
        }
        return (MFVec3f)this.getField("spine");
    }

    public void addSpine(float[] value) {
        this.getSpineField().addValue(value);
    }

    public void addSpine(float x, float y, float z) {
        this.getSpineField().addValue(x, y, z);
    }

    public int getNSpines() {
        return this.getSpineField().getSize();
    }

    public void setSpine(int index, float[] value) {
        this.getSpineField().set1Value(index, value);
    }

    public void setSpine(int index, float x, float y, float z) {
        this.getSpineField().set1Value(index, x, y, z);
    }

    public void setSpines(String value) {
        this.getSpineField().setValues(value);
    }

    public void setSpines(String[] value) {
        this.getSpineField().setValues(value);
    }

    public void getSpine(int index, float[] value) {
        this.getSpineField().get1Value(index, value);
    }

    public float[] getSpine(int index) {
        float[] value = new float[3];
        this.getSpine(index, value);
        return value;
    }

    public void removeSpine(int index) {
        this.getSpineField().removeValue(index);
    }

    public MFRotation getSetSetOrientationField() {
        if (!this.isInstanceNode()) {
            return this.setOrientationField;
        }
        return (MFRotation)this.getEventIn("orientation");
    }

    public void addSetSetOrientation(float[] value) {
        this.getSetSetOrientationField().addValue(value);
    }

    public void addSetSetOrientation(float x, float y, float z, float angle) {
        this.getSetSetOrientationField().addValue(x, y, z, angle);
    }

    public int getNSetSetOrientations() {
        return this.getSetSetOrientationField().getSize();
    }

    public void setSetSetOrientation(int index, float[] value) {
        this.getSetSetOrientationField().set1Value(index, value);
    }

    public void setSetSetOrientation(int index, float x, float y, float z, float angle) {
        this.getSetSetOrientationField().set1Value(index, x, y, z, angle);
    }

    public void setSetSetOrientations(String value) {
        this.getSetSetOrientationField().setValues(value);
    }

    public void setSetSetOrientations(String[] value) {
        this.getSetSetOrientationField().setValues(value);
    }

    public void getSetSetOrientation(int index, float[] value) {
        this.getSetSetOrientationField().get1Value(index, value);
    }

    public float[] getSetSetOrientation(int index) {
        float[] value = new float[4];
        this.getSetSetOrientation(index, value);
        return value;
    }

    public void removeSetSetOrientation(int index) {
        this.getSetSetOrientationField().removeValue(index);
    }

    public MFVec2f getSetScaleField() {
        if (!this.isInstanceNode()) {
            return this.setScaleField;
        }
        return (MFVec2f)this.getEventIn("scale");
    }

    public void addSetScale(float[] value) {
        this.getSetScaleField().addValue(value);
    }

    public void addSetScale(float x, float y) {
        this.getSetScaleField().addValue(x, y);
    }

    public int getNSetScales() {
        return this.getSetScaleField().getSize();
    }

    public void setSetScale(int index, float[] value) {
        this.getSetScaleField().set1Value(index, value);
    }

    public void setSetScale(int index, float x, float y) {
        this.getSetScaleField().set1Value(index, x, y);
    }

    public void setSetScales(String value) {
        this.getSetScaleField().setValues(value);
    }

    public void setSetScales(String[] value) {
        this.getSetScaleField().setValues(value);
    }

    public void getSetScale(int index, float[] value) {
        this.getSetScaleField().get1Value(index, value);
    }

    public float[] getSetScale(int index) {
        float[] value = new float[2];
        this.getSetScale(index, value);
        return value;
    }

    public void removeSetScale(int index) {
        this.getSetScaleField().removeValue(index);
    }

    public MFVec2f getSetCrossSectionField() {
        if (!this.isInstanceNode()) {
            return this.setCrossSectionField;
        }
        return (MFVec2f)this.getEventIn("crossSection");
    }

    public void addSetCrossSection(float[] value) {
        this.getSetCrossSectionField().addValue(value);
    }

    public void addSetCrossSection(float x, float y) {
        this.getSetCrossSectionField().addValue(x, y);
    }

    public int getNSetCrossSections() {
        return this.getSetCrossSectionField().getSize();
    }

    public void setSetCrossSection(int index, float[] value) {
        this.getSetCrossSectionField().set1Value(index, value);
    }

    public void setSetCrossSection(int index, float x, float y) {
        this.getSetCrossSectionField().set1Value(index, x, y);
    }

    public void setSetCrossSections(String value) {
        this.getSetCrossSectionField().setValues(value);
    }

    public void setSetCrossSections(String[] value) {
        this.getSetCrossSectionField().setValues(value);
    }

    public void getSetCrossSection(int index, float[] value) {
        this.getSetCrossSectionField().get1Value(index, value);
    }

    public float[] getSetCrossSection(int index) {
        float[] value = new float[2];
        this.getSetCrossSection(index, value);
        return value;
    }

    public void removeSetCrossSection(int index) {
        this.getSetCrossSectionField().removeValue(index);
    }

    public MFVec3f getSetSpineField() {
        if (!this.isInstanceNode()) {
            return this.setSpineField;
        }
        return (MFVec3f)this.getEventIn("spine");
    }

    public void addSetSpine(float[] value) {
        this.getSetSpineField().addValue(value);
    }

    public void addSetSpine(float x, float y, float z) {
        this.getSetSpineField().addValue(x, y, z);
    }

    public int getNSetSpines() {
        return this.getSetSpineField().getSize();
    }

    public void setSetSpine(int index, float[] value) {
        this.getSetSpineField().set1Value(index, value);
    }

    public void setSetSpine(int index, float x, float y, float z) {
        this.getSetSpineField().set1Value(index, x, y, z);
    }

    public void setSetSpines(String value) {
        this.getSetSpineField().setValues(value);
    }

    public void setSetSpines(String[] value) {
        this.getSetSpineField().setValues(value);
    }

    public void getSetSpine(int index, float[] value) {
        this.getSetSpineField().get1Value(index, value);
    }

    public float[] getSetSpine(int index) {
        float[] value = new float[3];
        this.getSetSpine(index, value);
        return value;
    }

    public void removeSetSpine(int index) {
        this.getSetSpineField().removeValue(index);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    public void addDefaultParameters() {
        if (this.getNCrossSections() == 0) {
            this.addCrossSection(1.0f, 1.0f);
            this.addCrossSection(1.0f, -1.0f);
            this.addCrossSection(-1.0f, -1.0f);
            this.addCrossSection(-1.0f, 1.0f);
            this.addCrossSection(1.0f, 1.0f);
        }
        if (this.getNSpines() == 0) {
            this.addSpine(0.0f, 0.0f, 0.0f);
            this.addSpine(0.0f, 1.0f, 0.0f);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBoundingBox();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool beginCap = this.getBeginCapField();
        SFBool endCap = this.getEndCapField();
        SFBool ccw = this.getCCWField();
        SFBool convex = this.getConvexField();
        SFBool solid = this.getSolidField();
        printStream.println(String.valueOf(indentString) + "\t" + "beginCap " + beginCap);
        printStream.println(String.valueOf(indentString) + "\t" + "endCap " + endCap);
        printStream.println(String.valueOf(indentString) + "\t" + "solid " + solid);
        printStream.println(String.valueOf(indentString) + "\t" + "ccw " + ccw);
        printStream.println(String.valueOf(indentString) + "\t" + "convex " + convex);
        printStream.println(String.valueOf(indentString) + "\t" + "creaseAngle " + this.getCreaseAngle());
        MFVec2f crossSection = this.getCrossSectionField();
        printStream.println(String.valueOf(indentString) + "\t" + "crossSection [");
        crossSection.outputContext(printStream, String.valueOf(indentString) + "\t\t");
        printStream.println(String.valueOf(indentString) + "\t" + "]");
        MFRotation orientation = this.getOrientationField();
        printStream.println(String.valueOf(indentString) + "\t" + "orientation [");
        orientation.outputContext(printStream, String.valueOf(indentString) + "\t\t");
        printStream.println(String.valueOf(indentString) + "\t" + "]");
        MFVec2f scale = this.getScaleField();
        printStream.println(String.valueOf(indentString) + "\t" + "scale [");
        scale.outputContext(printStream, String.valueOf(indentString) + "\t\t");
        printStream.println(String.valueOf(indentString) + "\t" + "]");
        MFVec3f spine = this.getSpineField();
        printStream.println(String.valueOf(indentString) + "\t" + "spine [");
        spine.outputContext(printStream, String.valueOf(indentString) + "\t\t");
        printStream.println(String.valueOf(indentString) + "\t" + "]");
    }

    @Override
    public void updateBoundingBox() {
        this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
        this.setBoundingBoxSize(-1.0f, -1.0f, -1.0f);
    }

    public int getVertexCount() {
        return this.getNCrossSections() * this.getNSpines();
    }

    public int getNTriangleCoordIndices() {
        int nCoordinateIndices = this.getNCrossSections() * 2 * (this.getNSpines() - 1) * 3;
        if (this.getConvex()) {
            if (this.getBeginCap()) {
                nCoordinateIndices += this.getNCrossSections() * 3;
            }
            if (this.getEndCap()) {
                nCoordinateIndices += this.getNCrossSections() * 3;
            }
        }
        return nCoordinateIndices;
    }
}

