/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;

public class ConeNode
extends Geometry3DNode {
    private static final String bottomRadiusFieldName = "bottomRadius";
    private static final String heightFieldName = "height";
    private static final String sideFieldName = "side";
    private static final String bottomFieldName = "bottom";
    private SFFloat bottomRadiusField;
    private SFFloat heightField;
    private SFBool sideField;
    private SFBool bottomField;

    public ConeNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.CONE);
        this.bottomRadiusField = new SFFloat(1.0f);
        this.addExposedField(bottomRadiusFieldName, this.bottomRadiusField);
        this.heightField = new SFFloat(2.0f);
        this.addExposedField(heightFieldName, this.heightField);
        this.sideField = new SFBool(true);
        this.addExposedField(sideFieldName, this.sideField);
        this.bottomField = new SFBool(true);
        this.addExposedField(bottomFieldName, this.bottomField);
    }

    public ConeNode(ConeNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFFloat getBottomRadiusField() {
        if (!this.isInstanceNode()) {
            return this.bottomRadiusField;
        }
        return (SFFloat)this.getExposedField(bottomRadiusFieldName);
    }

    public void setBottomRadius(float value) {
        this.getBottomRadiusField().setValue(value);
    }

    public void setBottomRadius(String value) {
        this.getBottomRadiusField().setValue(value);
    }

    public float getBottomRadius() {
        return this.getBottomRadiusField().getValue();
    }

    public SFFloat getHeightField() {
        if (!this.isInstanceNode()) {
            return this.heightField;
        }
        return (SFFloat)this.getExposedField(heightFieldName);
    }

    public void setHeight(float value) {
        this.getHeightField().setValue(value);
    }

    public void setHeight(String value) {
        this.getHeightField().setValue(value);
    }

    public float getHeight() {
        return this.getHeightField().getValue();
    }

    public SFBool getSideField() {
        if (!this.isInstanceNode()) {
            return this.sideField;
        }
        return (SFBool)this.getExposedField(sideFieldName);
    }

    public void setSide(boolean value) {
        this.getSideField().setValue(value);
    }

    public void setSide(String value) {
        this.getSideField().setValue(value);
    }

    public boolean getSide() {
        return this.getSideField().getValue();
    }

    public SFBool getBottomField() {
        if (!this.isInstanceNode()) {
            return this.bottomField;
        }
        return (SFBool)this.getExposedField(bottomFieldName);
    }

    public void setBottom(boolean value) {
        this.getBottomField().setValue(value);
    }

    public void setBottom(String value) {
        this.getBottomField().setValue(value);
    }

    public boolean getBottom() {
        return this.getBottomField().getValue();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBoundingBox();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void updateBoundingBox() {
        this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
        this.setBoundingBoxSize(this.getBottomRadius(), this.getHeight() / 2.0f, this.getBottomRadius());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool side = (SFBool)this.getExposedField(sideFieldName);
        SFBool bottom = (SFBool)this.getExposedField(bottomFieldName);
        printStream.println(String.valueOf(indentString) + "\t" + "bottomRadius " + this.getBottomRadius());
        printStream.println(String.valueOf(indentString) + "\t" + "height " + this.getHeight());
        printStream.println(String.valueOf(indentString) + "\t" + "side " + side);
        printStream.println(String.valueOf(indentString) + "\t" + "bottom " + bottom);
    }
}

