/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.BadTransformException;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.TextureTransformNode;

public class TextureTransformNodeObject
extends TextureAttributes
implements NodeObject {
    private float[] scale = new float[2];
    private float[] center = new float[2];
    private float rotation;
    private float[] translation = new float[2];
    private Vector3f vector = new Vector3f();
    private Vector3d factor = new Vector3d();
    private AxisAngle4f axisAngle = new AxisAngle4f();
    private Transform3D trans3D = new Transform3D();
    private Transform3D translationTrans3D = new Transform3D();
    private Transform3D centerTrans3D = new Transform3D();
    private Transform3D rotationrTrans3D = new Transform3D();
    private Transform3D scaleTrans3D = new Transform3D();
    private Transform3D minusCenterTrans3D = new Transform3D();
    private Transform3D transform = new Transform3D();

    public TextureTransformNodeObject(TextureTransformNode node) {
        this.setCapability(4);
        this.setCapability(5);
        this.initialize(node);
    }

    @Override
    public boolean initialize(Node node) {
        node.setRunnable(true);
        node.setRunnableType(1);
        this.update(node);
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    @Override
    public boolean update(Node node) {
        TextureTransformNode texTransNode = (TextureTransformNode)node;
        texTransNode.getScale(this.scale);
        texTransNode.getCenter(this.center);
        texTransNode.getTranslation(this.translation);
        this.rotation = texTransNode.getRotation();
        this.trans3D.setIdentity();
        this.translationTrans3D.setIdentity();
        this.vector.x = this.translation[0];
        this.vector.y = this.translation[1];
        this.vector.z = 0.0f;
        this.translationTrans3D.set(this.vector);
        this.trans3D.mul(this.translationTrans3D);
        this.centerTrans3D.setIdentity();
        this.vector.x = this.center[0];
        this.vector.y = this.center[1];
        this.vector.z = 0.0f;
        this.centerTrans3D.set(this.vector);
        this.trans3D.mul(this.centerTrans3D);
        this.rotationrTrans3D.setIdentity();
        this.axisAngle.x = 0.0f;
        this.axisAngle.y = 0.0f;
        this.axisAngle.z = 1.0f;
        this.axisAngle.angle = this.rotation;
        this.rotationrTrans3D.set(this.axisAngle);
        this.trans3D.mul(this.rotationrTrans3D);
        this.scaleTrans3D.setIdentity();
        this.factor.x = this.scale[0];
        this.factor.y = this.scale[1];
        this.factor.z = 1.0;
        this.scaleTrans3D.set(this.factor);
        this.trans3D.mul(this.scaleTrans3D);
        this.centerTrans3D.setIdentity();
        this.vector.x = -this.center[0];
        this.vector.y = -this.center[1];
        this.vector.z = 0.0f;
        this.centerTrans3D.set(this.vector);
        this.trans3D.mul(this.centerTrans3D);
        try {
            this.setTextureTransform(this.trans3D);
        }
        catch (BadTransformException badTransformException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isAppearanceNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Appearance parentAppearanceNode = (Appearance)parentNodeObject;
            parentAppearanceNode.setTextureAttributes((TextureAttributes)this);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isAppearanceNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Appearance parentAppearanceNode = (Appearance)parentNodeObject;
            parentAppearanceNode.setTextureAttributes(null);
        }
        return true;
    }
}

