/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import java.awt.Font;
import javax.media.j3d.Font3D;
import javax.media.j3d.FontExtrusion;
import javax.media.j3d.Geometry;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Text3D;
import org.cybergarage.x3d.node.FontStyleNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.TextNode;
import org.cybergarage.x3d.util.Debug;

public class TextNodeObject
extends Text3D
implements NodeObject {
    public TextNodeObject(TextNode node) {
        this.setCapability(2);
        this.setCapability(3);
        this.setCapability(18);
        this.initialize(node);
    }

    @Override
    public boolean initialize(Node node) {
        Debug.message("TextNodeObject::initialize = " + node);
        TextNode textNode = (TextNode)node;
        String fontName = "SansSerif";
        float fontSize = 1.0f;
        int fontStyle = 0;
        FontStyleNode fontStyleNode = textNode.getFontStyleNodes();
        if (fontStyleNode != null) {
            String justify;
            if (1 <= fontStyleNode.getNFamilies()) {
                String family = fontStyleNode.getFamily(0);
                if (family.equals("SERIF")) {
                    fontName = "SansSerif";
                } else if (family.equals("SANS")) {
                    fontName = "Helvetica";
                } else if (family.equals("TYPEWRITER")) {
                    fontName = "Courier";
                }
            }
            fontSize = fontStyleNode.getSize();
            String style = fontStyleNode.getStyle();
            if (style.equals("PLAIN")) {
                fontStyle = 0;
            } else if (style.equals("BOLD")) {
                fontStyle = 1;
            } else if (style.equals("ITALIC")) {
                fontStyle = 2;
            } else if (style.equals("BOLDITALIC")) {
                fontStyle = 3;
            }
            if (1 <= fontStyleNode.getNJustifies() && (justify = fontStyleNode.getJustify(0)) != null) {
                if (justify.equals("MIDDLE")) {
                    this.setAlignment(0);
                }
                if (justify.equals("FIRST")) {
                    this.setAlignment(1);
                }
                if (justify.equals("BEGIN")) {
                    this.setAlignment(1);
                }
                if (justify.equals("END")) {
                    this.setAlignment(2);
                }
            }
        }
        this.setFont3D(new Font3D(new Font(fontName, fontStyle, (int)fontSize), new FontExtrusion()));
        this.update(node);
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    @Override
    public boolean update(Node node) {
        TextNode textNode = (TextNode)node;
        String textString = null;
        int nStrings = textNode.getNStrings();
        if (1 <= nStrings) {
            textString = textNode.getString(0);
        }
        String textNodeString = this.getString();
        if (textString == null && textNodeString == null) {
            return true;
        }
        if (textString != null) {
            if (!textString.equals(textNodeString)) {
                this.setString(textString);
            }
        } else {
            this.setString("");
        }
        return true;
    }

    @Override
    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry(null);
        }
        return true;
    }
}

