/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Group;
import javax.media.j3d.Switch;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.j3d.SceneGraphJ3dObject;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.SwitchNode;

public class SwitchNodeObject
extends Switch
implements NodeObject {
    public SwitchNodeObject() {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(17);
        this.setCapability(18);
    }

    public SwitchNodeObject(SwitchNode node) {
        this();
    }

    @Override
    public boolean initialize(Node node) {
        this.update(node);
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    @Override
    public boolean update(Node node) {
        int whichChoice;
        SwitchNode switchNode = (SwitchNode)node;
        int j3dWhichChild = this.getWhichChild();
        if (j3dWhichChild != (whichChoice = switchNode.getWhichChoice()) && whichChoice >= 0 && whichChoice < this.numChildren()) {
            this.setWhichChild(whichChoice);
        }
        return true;
    }

    public Group getParentGroup(Node node) {
        Node parentNode = node.getParentNode();
        Object parentGroupNode = null;
        if (parentNode != null) {
            NodeObject parentNodeObject = parentNode.getObject();
            if (parentNodeObject != null) {
                parentGroupNode = (Group)parentNodeObject;
            }
        } else {
            SceneGraphJ3dObject sgObject;
            SceneGraph sg = node.getSceneGraph();
            if (sg != null && (sgObject = (SceneGraphJ3dObject)sg.getObject()) != null) {
                parentGroupNode = sgObject.getRootNode();
            }
        }
        return parentGroupNode;
    }

    @Override
    public boolean add(Node node) {
        Group parentGroupNode;
        if (this.getParent() == null && (parentGroupNode = this.getParentGroup(node)) != null) {
            parentGroupNode.addChild((javax.media.j3d.Node)this);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        Group parentGroupNode = this.getParentGroup(node);
        if (parentGroupNode != null) {
            int n = 0;
            while (n < parentGroupNode.numChildren()) {
                if (parentGroupNode.getChild(n) == this) {
                    parentGroupNode.removeChild(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void removeAllChildren() {
        while (this.numChildren() > 0) {
            this.removeChild(this.numChildren() - 1);
        }
    }
}

