/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.IndexedPointArray;
import javax.media.j3d.Material;
import javax.media.j3d.Shape3D;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.PointSetNode;

public class PointSetNodeObject
extends IndexedPointArray
implements NodeObject {
    public PointSetNodeObject(PointSetNode node) {
        super(PointSetNodeObject.getVertexCount(node), PointSetNodeObject.getVertexFormat(node), PointSetNodeObject.getVertexCount(node));
        this.setCapability(18);
        this.initialize(node);
    }

    public static int getVertexCount(PointSetNode node) {
        return node.getCoordinateNodes() != null ? node.getCoordinateNodes().getNPoints() : 0;
    }

    public static int getVertexFormat(PointSetNode node) {
        int vertexFormat = 1;
        if (node.getColorNodes() != null) {
            vertexFormat |= 4;
        }
        return vertexFormat;
    }

    private void disableLightInMaterialNode(Node node) {
        Material material;
        Shape3D parentShape3DNode;
        Appearance app;
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null && (app = (parentShape3DNode = (Shape3D)parentNodeObject).getAppearance()) != null && (material = app.getMaterial()) != null) {
            material.setLightingEnable(false);
        }
    }

    @Override
    public boolean initialize(Node node) {
        ColorNode colorNode;
        PointSetNode pointSetNode = (PointSetNode)node;
        CoordinateNode coordNode = pointSetNode.getCoordinateNodes();
        if (coordNode != null) {
            int nCoordinatePoints = coordNode.getNPoints();
            float[] point = new float[3];
            int n = 0;
            while (n < nCoordinatePoints) {
                coordNode.getPoint(n, point);
                this.setCoordinate(n, point);
                ++n;
            }
            n = 0;
            while (n < nCoordinatePoints) {
                this.setCoordinateIndex(n, n);
                ++n;
            }
        }
        if ((colorNode = pointSetNode.getColorNodes()) != null) {
            int nColors = colorNode.getNColors();
            float[] color = new float[3];
            int n = 0;
            while (n < nColors) {
                colorNode.getColor(n, color);
                this.setColor(n, color);
                ++n;
            }
            n = 0;
            while (n < nColors) {
                this.setColorIndex(n, n);
                ++n;
            }
        }
        this.disableLightInMaterialNode(node);
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    @Override
    public boolean update(Node node) {
        return true;
    }

    @Override
    public boolean add(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry((Geometry)this);
            this.disableLightInMaterialNode(node);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        NodeObject parentNodeObject;
        Node parentNode = node.getParentNode();
        if (parentNode != null && parentNode.isShapeNode() && (parentNodeObject = parentNode.getObject()) != null) {
            Shape3D parentShape3DNode = (Shape3D)parentNodeObject;
            parentShape3DNode.setGeometry(null);
        }
        return true;
    }
}

