/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.j3d;

import javax.media.j3d.Group;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.AxisAngle4f;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.j3d.SceneGraphJ3dObject;
import org.cybergarage.x3d.node.BillboardNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.util.Geometry3D;

public class BillboardNodeObject
extends TransformGroup
implements NodeObject {
    public BillboardNodeObject(BillboardNode node) {
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(17);
        this.setCapability(18);
        this.initialize(node);
    }

    @Override
    public boolean initialize(Node node) {
        this.update(node);
        return true;
    }

    @Override
    public boolean uninitialize(Node node) {
        return true;
    }

    private float[] getViewerToBillboardVector(BillboardNode bbNode) {
        SceneGraph sg = bbNode.getSceneGraph();
        if (sg == null) {
            return null;
        }
        ViewpointNode view = sg.getViewpointNode();
        if (view == null) {
            view = sg.getDefaultViewpointNode();
        }
        float[] viewPos = new float[3];
        view.getPosition(viewPos);
        float[] bboardPos = new float[]{0.0f, 0.0f, 0.0f};
        Node parentNode = bbNode.getParentNode();
        if (parentNode != null) {
            SFMatrix mx = new SFMatrix();
            parentNode.getTransformMatrix(mx);
            mx.multi(bboardPos);
        }
        SFVec3f resultVector = new SFVec3f(bboardPos);
        resultVector.sub(viewPos);
        resultVector.normalize();
        float[] vector = new float[3];
        resultVector.getValue(vector);
        return vector;
    }

    private float[] getBillboardToViewerVector(BillboardNode bbNode) {
        float[] vector = this.getViewerToBillboardVector(bbNode);
        Geometry3D.inverse(vector);
        return vector;
    }

    private float getRotationAngleOfZAxis(BillboardNode bbNode) {
        float[] axisOfRotation = new float[3];
        bbNode.getAxisOfRotation(axisOfRotation);
        float[] viewer2bboardVector = this.getViewerToBillboardVector(bbNode);
        float[] planeVector = Geometry3D.getCross(axisOfRotation, viewer2bboardVector);
        float[] zAxisVectorOnPlane = Geometry3D.getCross(axisOfRotation, planeVector);
        float[] zAxisVector = new float[]{0.0f, 0.0f, 1.0f};
        return Geometry3D.getAngle(zAxisVector, zAxisVectorOnPlane);
    }

    private void getRotationZAxisRotation(BillboardNode bbNode, float[] roationValue) {
        SceneGraph sg = bbNode.getSceneGraph();
        if (sg == null) {
            return;
        }
        float[] bboardYAxisVector = new float[]{0.0f, 1.0f, 0.0f};
        float[] bboardZAxisVector = new float[]{0.0f, 0.0f, 1.0f};
        float[] bboard2viewerVector = this.getBillboardToViewerVector(bbNode);
        float[] planeVector = Geometry3D.getCross(bboardZAxisVector, bboard2viewerVector);
        float bboardZAxisRotationAngle = Geometry3D.getAngle(bboardZAxisVector, bboard2viewerVector);
        SFRotation zAxisRotation = new SFRotation();
        zAxisRotation.setValue(planeVector, bboardZAxisRotationAngle);
        zAxisRotation.multi(bboardYAxisVector);
        ViewpointNode view = sg.getViewpointNode();
        if (view == null) {
            view = sg.getDefaultViewpointNode();
        }
        float[][] viewFrame = new float[3][3];
        view.getFrame(viewFrame);
        float bboardYAxisRotationAngle = Geometry3D.getAngle(viewFrame[1], bboardYAxisVector);
        if (viewFrame[1][0] > 0.0f) {
            bboardYAxisRotationAngle = (float)Math.PI * 2 - bboardYAxisRotationAngle;
        }
        SFRotation yAxisRotation = new SFRotation();
        yAxisRotation.setValue(viewFrame[2], bboardYAxisRotationAngle);
        SFRotation rotation = new SFRotation();
        rotation.add(yAxisRotation);
        rotation.add(zAxisRotation);
        rotation.getValue(roationValue);
    }

    private void getRotation(BillboardNode bbNode, float[] rotation) {
        if (Geometry3D.length(rotation) > 0.0f) {
            bbNode.getAxisOfRotation(rotation);
            rotation[3] = -this.getRotationAngleOfZAxis(bbNode);
        } else {
            this.getRotationZAxisRotation(bbNode, rotation);
        }
    }

    @Override
    public boolean update(Node node) {
        BillboardNode bbNode = (BillboardNode)node;
        float[] rotation = new float[4];
        this.getRotation(bbNode, rotation);
        Transform3D trans3D = new Transform3D();
        this.getTransform(trans3D);
        AxisAngle4f axisAngle = new AxisAngle4f(rotation);
        trans3D.setRotation(axisAngle);
        this.setTransform(trans3D);
        return true;
    }

    public Group getParentGroup(Node node) {
        Node parentNode = node.getParentNode();
        Object parentGroupNode = null;
        if (parentNode != null) {
            NodeObject parentNodeObject = parentNode.getObject();
            if (parentNodeObject != null) {
                parentGroupNode = (Group)parentNodeObject;
            }
        } else {
            SceneGraphJ3dObject sgObject;
            SceneGraph sg = node.getSceneGraph();
            if (sg != null && (sgObject = (SceneGraphJ3dObject)sg.getObject()) != null) {
                parentGroupNode = sgObject.getRootNode();
            }
        }
        return parentGroupNode;
    }

    @Override
    public boolean add(Node node) {
        Group parentGroupNode;
        if (this.getParent() == null && (parentGroupNode = this.getParentGroup(node)) != null) {
            parentGroupNode.addChild((javax.media.j3d.Node)this);
        }
        return true;
    }

    @Override
    public boolean remove(Node node) {
        Group parentGroupNode = this.getParentGroup(node);
        if (parentGroupNode != null) {
            int n = 0;
            while (n < parentGroupNode.numChildren()) {
                if (parentGroupNode.getChild(n) == this) {
                    parentGroupNode.removeChild(n);
                    return true;
                }
                ++n;
            }
        }
        return false;
    }
}

