/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class FieldTokenizer
extends StreamTokenizer {
    public FieldTokenizer(Reader reader) {
        super(reader);
        this.initializeTokenizer();
    }

    public FieldTokenizer(Reader reader, String whitespaceChars) {
        this(reader);
        this.addWhiteSpaceChars(whitespaceChars);
    }

    public FieldTokenizer(Reader reader, String whitespaceChars, String wordChars) {
        this(reader, whitespaceChars);
        this.addWordChars(wordChars);
    }

    public FieldTokenizer(String string) {
        this(new StringReader(string));
    }

    public FieldTokenizer(String string, String whitespaceChars) {
        this(string);
        this.addWhiteSpaceChars(whitespaceChars);
    }

    public FieldTokenizer(String string, String whitespaceChars, String wordChars) {
        this(string, whitespaceChars);
        this.addWordChars(wordChars);
    }

    public void initializeTokenizer() {
        this.eolIsSignificant(false);
        this.resetSyntax();
        this.wordChars(65, 90);
        this.wordChars(97, 122);
        this.wordChars(48, 57);
        this.wordChars(43, 43);
        this.wordChars(45, 45);
        this.wordChars(95, 95);
        this.wordChars(46, 46);
        this.whitespaceChars(44, 44);
        this.whitespaceChars(32, 32);
        this.quoteChar(34);
    }

    public void addWhiteSpaceChars(String whitespaceChars) {
        if (whitespaceChars == null) {
            return;
        }
        int length = whitespaceChars.length();
        int n = 0;
        while (n < length) {
            char c = whitespaceChars.charAt(n);
            this.whitespaceChars(c, c);
            ++n;
        }
    }

    public void addWordChars(String wordChars) {
        if (wordChars == null) {
            return;
        }
        int length = wordChars.length();
        int n = 0;
        while (n < length) {
            char c = wordChars.charAt(n);
            this.wordChars(c, c);
            ++n;
        }
    }
}

