/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d;

import java.io.PrintWriter;
import java.util.Vector;
import org.cybergarage.x3d.BaseNode;
import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.field.MFieldMultiValueTokenizer;
import org.cybergarage.x3d.field.MFieldSingleValueTokenizer;
import org.cybergarage.x3d.util.Debug;

public abstract class MField
extends Field {
    private Vector mFieldVector = new Vector();

    public MField() {
    }

    public MField(MField field) {
        this.setObject(field.getObject());
    }

    @Override
    public void setObject(Object object) {
        this.mFieldVector = (Vector)object;
    }

    @Override
    public Object getObject() {
        return this.mFieldVector;
    }

    public int getSize() {
        return this.mFieldVector.size();
    }

    public int size() {
        return this.mFieldVector.size();
    }

    public void add(Object object) {
        this.mFieldVector.addElement(object);
    }

    public void add(Field field) {
        this.add((Object)field);
    }

    public abstract void addValue(String var1);

    public void add(String string) {
        this.addValue(string);
    }

    public abstract void insertValue(int var1, String var2);

    public void insert(int index, Object object) {
        this.mFieldVector.insertElementAt(object, index);
    }

    public void insert(int index, Field field) {
        this.insert(index, (Object)field);
    }

    public void insert(int index, String string) {
        this.insertValue(index, string);
    }

    public void clear() {
        this.mFieldVector.removeAllElements();
    }

    public void delete(int index) {
        this.mFieldVector.removeElementAt(index);
    }

    public void remove(int index) {
        this.mFieldVector.removeElementAt(index);
    }

    public void removeValue(int index) {
        this.remove(index);
    }

    public void removeAllValues() {
        this.clear();
    }

    public Object get(int index) {
        if (index < this.size()) {
            return this.mFieldVector.elementAt(index);
        }
        return null;
    }

    public Field getField(int index) {
        return (Field)this.get(index);
    }

    public void set(int index, Object object) {
        this.mFieldVector.setElementAt(object, index);
    }

    public void setField(int index, Field field) {
        this.set(index, field);
    }

    public void setBaseNode(int index, BaseNode node) {
        this.set(index, node);
    }

    public void copy(MField srcMField) {
        this.clear();
        int n = 0;
        while (n < srcMField.getSize()) {
            this.add(srcMField.get(n));
            ++n;
        }
    }

    public abstract void outputContext(PrintWriter var1, String var2);

    @Override
    public void setValue(String string) {
        String[] token = null;
        token = this.isSingleValueMField() ? MFieldSingleValueTokenizer.getTokens(string) : MFieldMultiValueTokenizer.getTokens(string);
        Debug.message("setValue(" + string + ")");
        int n = 0;
        while (n < token.length) {
            Debug.message("  [" + n + "] = " + token[n]);
            ++n;
        }
        this.setValue(token);
    }

    public void setValue(String[] value) {
        if (value == null) {
            return;
        }
        this.clear();
        int size = value.length;
        int n = 0;
        while (n < size) {
            this.add(value[n]);
            ++n;
        }
    }

    public void setValues(String value) {
        this.setValue(value);
    }

    public void setValues(String[] value) {
        this.setValue(value);
    }

    @Override
    public void setValue(Field field) {
        if (field instanceof MField) {
            this.setValue((MField)field);
        }
    }

    public void setValue(MField field) {
        this.copy(field);
    }
}

