/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.terminal;

import ciss.phase_viewer.ssh.SessionCreator;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.MyUserInfo;
import ciss.phase_viewer.ssh.terminal.Terminal;
import com.jcraft.jcterm.Emulator;
import com.jcraft.jcterm.EmulatorVT100;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.Session;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class TermPanel
extends JPanel
implements KeyListener,
Runnable,
Term {
    private static Logger logger = Logger.getLogger((String)TermPanel.class.getName());
    private OutputStream out;
    private InputStream in;
    private BufferedImage img;
    private BufferedImage background;
    private Graphics2D cursor_graphics;
    private Graphics2D graphics;
    private Color bground = Color.white;
    private Color fground = Color.black;
    private Component term_area = null;
    private Font font;
    private Splash splash = null;
    private int term_width = 80;
    private int term_height = 24;
    private int orig_term_width = this.term_width;
    private int orig_term_height = this.term_height;
    private int x = 0;
    private int y = 0;
    private int descent = 0;
    private int wsav;
    private int hsav;
    private int char_width;
    private int char_height;
    private boolean xforwarding = true;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private Session session = null;
    private boolean antialiasing = true;
    private int line_space = -2;
    private HostInfo hostinfo;
    private MyUserInfo userinfo;
    private String user;
    private String hostname;
    private int origw;
    private int origh;
    private JInternalFrame parent;
    private String initCommand;
    private boolean initDone = false;
    private Terminal terminal;
    private Thread thread = null;
    private Emulator emulator = null;
    private int retries = 0;
    private int max = 4;
    private byte[] obuffer = new byte[3];

    public TermPanel() {
        this("", null);
    }

    public TermPanel(String initCommand, Terminal terminal) {
        this.parent = this.parent;
        this.initCommand = initCommand;
        this.terminal = terminal;
        this.font = Font.decode("Monospaced-14");
        this.img = new BufferedImage(1, 1, 1);
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.graphics.setFont(this.font);
        FontMetrics fo = this.graphics.getFontMetrics();
        this.descent = fo.getDescent();
        this.char_width = fo.charWidth('@');
        this.char_height = fo.getHeight() + this.line_space * 2;
        this.descent += this.line_space;
        this.img.flush();
        this.graphics.dispose();
        this.background = new BufferedImage(this.char_width, this.char_height, 1);
        Graphics2D foog = (Graphics2D)this.background.getGraphics();
        foog.setColor(this.bground);
        foog.fillRect(0, 0, this.char_width, this.char_height);
        foog.dispose();
        this.img = new BufferedImage(this.getTermWidth(), this.getTermHeight(), 1);
        this.graphics = (Graphics2D)this.img.getGraphics();
        this.graphics.setFont(this.font);
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.cursor_graphics = (Graphics2D)this.img.getGraphics();
        this.cursor_graphics.setColor(this.fground);
        this.cursor_graphics.setXORMode(this.bground);
        this.setAntiAliasing(this.antialiasing);
        this.term_area = this;
        TermPanel panel = this;
        panel.setPreferredSize(new Dimension(this.getTermWidth(), this.getTermHeight()));
        this.wsav = this.getTermWidth();
        this.hsav = this.getTermHeight();
        panel.setSize(this.getTermWidth(), this.getTermHeight());
        panel.setFocusable(true);
        panel.enableInputMethods(true);
        panel.setFocusTraversalKeysEnabled(false);
        this.origw = this.getSize().width;
        this.origh = this.getSize().height;
    }

    public void setFrame(Component term_area) {
        this.term_area = term_area;
    }

    public void connect(HostInfo hostinfo) {
        this.hostinfo = hostinfo;
        this.antialiasing = hostinfo.getBooleanProperty("antialiasing");
        this.setAntiAliasing(this.antialiasing);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void disconnect() {
        if (this.session != null) {
            if (this.thread != null) {
                this.thread = null;
            }
            try {
                this.session.disconnect();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.session = null;
        }
    }

    protected void parentResized(double scalew, double scaleh) {
        this.setSize((int)scalew * this.origw, (int)scaleh * this.origh);
    }

    @Override
    public void run() {
        Object jsch = null;
        while (this.thread != null) {
            try {
                if (this.session != null && this.session.isConnected()) continue;
                try {
                    ++this.retries;
                    if (this.retries == this.max) {
                        logger.error((Object)"exceeded max retries");
                        break;
                    }
                    this.session = SessionCreator.getSession(this.hostinfo);
                    this.session.setTimeout(0);
                    logger.info((Object)"connected");
                }
                catch (Exception e) {
                    logger.error((Object)"failed connection...");
                    e.printStackTrace();
                }
                if (this.session != null) {
                    logger.debug((Object)("connected? " + this.session.isConnected()));
                }
                Channel channel = null;
                if (this.session == null) continue;
                channel = this.session.openChannel("shell");
                this.xforwarding = this.hostinfo.getBooleanProperty("xforwarding");
                if (this.xforwarding) {
                    this.session.setX11Host(this.xhost);
                    this.session.setX11Port(this.xport + 6000);
                    channel.setXForwarding(true);
                }
                this.out = channel.getOutputStream();
                this.in = channel.getInputStream();
                channel.connect();
                if (!this.initDone && this.initCommand != null && this.initCommand.length() != 0) {
                    byte[] init = new String(String.valueOf(this.initCommand) + "\n").getBytes();
                    this.out.write(init);
                    this.out.flush();
                }
                this.initDone = true;
                this.requestFocus();
                this.emulator = new EmulatorVT100(this, this.in);
                this.emulator.reset();
                this.emulator.start();
            }
            catch (Exception exc) {
                logger.info((Object)"not connected.");
                exc.printStackTrace();
            }
        }
        this.thread = null;
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.redraw(0, 0, this.getTermWidth(), this.getTermHeight());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.img != null) {
            g.drawImage(this.img, 0, 0, this.term_area);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent e) {
        int id = e.getID();
        if (id == 401) {
            this.keyPressed(e);
        } else if (id != 402 && id == 400) {
            this.keyTyped(e);
        }
        e.consume();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        byte[] code = null;
        switch (keycode) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return;
            }
            case 10: {
                code = this.emulator.getCodeENTER();
                break;
            }
            case 38: {
                code = this.emulator.getCodeUP();
                break;
            }
            case 40: {
                code = this.emulator.getCodeDOWN();
                break;
            }
            case 39: {
                code = this.emulator.getCodeRIGHT();
                break;
            }
            case 37: {
                code = this.emulator.getCodeLEFT();
                break;
            }
            case 112: {
                code = this.emulator.getCodeF1();
                break;
            }
            case 113: {
                code = this.emulator.getCodeF2();
                break;
            }
            case 114: {
                code = this.emulator.getCodeF3();
                break;
            }
            case 115: {
                code = this.emulator.getCodeF4();
                break;
            }
            case 116: {
                code = this.emulator.getCodeF5();
                break;
            }
            case 117: {
                code = this.emulator.getCodeF6();
                break;
            }
            case 118: {
                code = this.emulator.getCodeF7();
                break;
            }
            case 119: {
                code = this.emulator.getCodeF8();
                break;
            }
            case 120: {
                code = this.emulator.getCodeF9();
                break;
            }
            case 121: {
                code = this.emulator.getCodeF10();
            }
        }
        if (code != null) {
            try {
                this.out.write(code, 0, code.length);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) == 0) {
            this.obuffer[0] = (byte)e.getKeyChar();
            try {
                this.out.write(this.obuffer, 0, 1);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        char keychar = e.getKeyChar();
        if ((keychar & 0xFF00) != 0) {
            char[] foo = new char[]{keychar};
            try {
                byte[] goo = new String(foo).getBytes("EUC-JP");
                this.out.write(goo, 0, goo.length);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    public int getTermWidth() {
        return this.char_width * this.term_width;
    }

    public int getTermHeight() {
        return this.char_height * this.term_height;
    }

    @Override
    public int getCharWidth() {
        return this.char_width;
    }

    @Override
    public int getCharHeight() {
        return this.char_height;
    }

    @Override
    public int getColumnCount() {
        return this.term_width;
    }

    @Override
    public int getRowCount() {
        return this.term_height;
    }

    @Override
    public void clear() {
        this.graphics.setColor(this.bground);
        this.graphics.fillRect(0, 0, this.char_width * this.term_width, this.char_height * this.term_height);
        this.graphics.setColor(this.fground);
    }

    @Override
    public void setCursor(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void draw_cursor() {
        this.cursor_graphics.fillRect(this.x, this.y - this.char_height, this.char_width, this.char_height);
        Graphics g = this.getGraphics();
        g.setClip(this.x, this.y - this.char_height, this.char_width, this.char_height);
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    @Override
    public void redraw(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        if (g == null) {
            return;
        }
        g.setClip(x, y, width, height);
        g.drawImage(this.img, 0, 0, this.term_area);
    }

    @Override
    public void clear_area(int x1, int y1, int x2, int y2) {
        this.graphics.setColor(this.bground);
        this.graphics.fillRect(x1, y1, x2 - x1, y2 - y1);
        this.graphics.setColor(this.fground);
    }

    @Override
    public void scroll_area(int x, int y, int w, int h, int dx, int dy) {
        this.getGraphics().copyArea(x, y, w, h, dx, dy);
        this.graphics.copyArea(x, y, w, h, dx, dy);
    }

    @Override
    public void drawBytes(byte[] buf, int s, int len, int x, int y) {
        this.graphics.drawBytes(buf, s, len, x, y - this.descent);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.graphics.drawString(str, x, y - this.descent);
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public void setXHost(String xhost) {
        this.xhost = xhost;
    }

    public void setXPort(int xport) {
        this.xport = xport;
    }

    public void setXForwarding(boolean foo) {
        this.xforwarding = foo;
    }

    public void setLineSpace(int foo) {
        this.line_space = foo;
    }

    public void setAntiAliasing(boolean foo) {
        if (this.graphics == null) {
            return;
        }
        this.antialiasing = foo;
        Object mode = foo ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, mode);
        this.graphics.setRenderingHints(hints);
    }

    public void quit() {
        this.thread = null;
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    @Override
    public void setFGround(Object f) {
        if (f instanceof String) {
            this.fground = Color.getColor((String)f);
        }
        if (f instanceof Color) {
            this.fground = (Color)f;
        }
        this.graphics.setColor(this.fground);
    }

    @Override
    public void setBGround(Object b) {
        if (b instanceof String) {
            this.bground = Color.getColor((String)b);
        }
        if (b instanceof Color) {
            this.bground = (Color)b;
        }
        Graphics2D foog = (Graphics2D)this.background.getGraphics();
        foog.setColor(this.bground);
        foog.fillRect(0, 0, this.char_width, this.char_height);
        foog.dispose();
    }

    @Override
    public Object getFGround() {
        return this.fground;
    }

    @Override
    public Object getBGround() {
        return this.bground;
    }
}

