/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.hosts.HostSelector;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class HostSelectorTable
extends JTable
implements HostSelector {
    private Logger logger = Logger.getLogger((String)HostSelectorTable.class.getName());
    private HostList list = HostList.getHostList();
    private static HostSelectorTable ta;

    public HostSelectorTable() {
        this.init();
    }

    private void init() {
        this.setPreferredScrollableViewportSize(new Dimension(250, 10));
        this.setSelectionMode(0);
        TableMod model = new TableMod();
        model.addColumn("hostname");
        model.addColumn("default");
        model.addTableModelListener(new Listener());
        this.setModel(model);
        JCheckBox cb = new JCheckBox();
        DefaultCellEditor dce = new DefaultCellEditor(cb);
        this.getColumn("default").setCellEditor(dce);
        JTextField tf = new JTextField("");
        tf.setEditable(false);
        DefaultCellEditor dcet = new DefaultCellEditor(tf);
        this.getColumn("hostname").setCellEditor(dcet);
        int i = 0;
        while (i < this.list.size()) {
            HostInfo info = this.list.getHostInfo(i);
            Object[] obj = new Object[]{info.getName(), new Boolean(info.getBooleanProperty("default"))};
            ((DefaultTableModel)this.getModel()).addRow(obj);
            ++i;
        }
    }

    @Override
    public HostList getListofHosts() {
        return this.list;
    }

    @Override
    public HostInfo getSelectedHost() {
        int i = this.getSelectedRow();
        if (i >= 0) {
            return this.list.getHostInfo(i);
        }
        return this.list.getDefaultHost();
    }

    @Override
    public int getSelectedIndex() {
        return this.getSelectedRow();
    }

    public void recreate() {
        this.removeAll();
        this.init();
    }

    @Override
    public void addHost(HostInfo hostInfo) {
        ((DefaultTableModel)this.getModel()).addRow(new Object[]{hostInfo.getName(), new Boolean(false)});
        this.list.add(hostInfo);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setSize(200, 100);
        JScrollPane scr = new JScrollPane();
        ta = new HostSelectorTable();
        ta.setPreferredScrollableViewportSize(new Dimension(200, 70));
        scr.getViewport().add(ta);
        JButton btn = new JButton("add");
        JPanel pp = new JPanel();
        pp.add(btn);
        pp.add(scr);
        frame.getContentPane().add(pp);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(3);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ta.addHost(new HostInfo("foobar"));
            }
        });
    }

    private int getDefIndex() {
        int i = 0;
        while (i < this.getRowCount()) {
            Object b = this.getValueAt(i, 1);
            if (b instanceof Boolean && ((Boolean)b).booleanValue()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public void deleteSelectedHost() {
        int ind = this.getSelectedRow();
        this.list.remove(ind);
        ((DefaultTableModel)this.getModel()).removeRow(ind);
    }

    class ListSelectLis
    implements ListSelectionListener {
        ListSelectLis() {
        }

        @Override
        public void valueChanged(ListSelectionEvent arg0) {
            int column = HostSelectorTable.this.getSelectedColumn();
            if (column != 1) {
                return;
            }
            int row = HostSelectorTable.this.getSelectedRow();
            TableModelListener[] lists = ((DefaultTableModel)HostSelectorTable.this.getModel()).getTableModelListeners();
            int i = 0;
            while (i < lists.length) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).removeTableModelListener(lists[i]);
                ++i;
            }
            i = 0;
            while (i < HostSelectorTable.this.getRowCount()) {
                HostSelectorTable.this.setValueAt(new Boolean(false), i, 1);
                ++i;
            }
            HostSelectorTable.this.repaint();
            HostSelectorTable.this.revalidate();
            HostSelectorTable.this.setValueAt(new Boolean(true), row, 1);
            i = 0;
            while (i < lists.length) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).addTableModelListener(lists[i]);
                ++i;
            }
        }
    }

    class Listener
    implements TableModelListener {
        Listener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            if (column != 1) {
                return;
            }
            int row = e.getFirstRow();
            int larow = e.getLastRow();
            int defind = HostSelectorTable.this.getDefIndex();
            TableModelListener[] lists = ((DefaultTableModel)HostSelectorTable.this.getModel()).getTableModelListeners();
            int i = 0;
            while (i < lists.length) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).removeTableModelListener(lists[i]);
                ++i;
            }
            i = 0;
            while (i < HostSelectorTable.this.getRowCount()) {
                if (i != row) {
                    HostSelectorTable.this.setValueAt(new Boolean(false), i, 1);
                    HostSelectorTable.this.list.getHostInfo(i).setProperty("default", "false");
                }
                ++i;
            }
            HostSelectorTable.this.setValueAt(new Boolean(true), row, 1);
            HostSelectorTable.this.list.getHostInfo(row).setProperty("default", "true");
            HostSelectorTable.this.repaint();
            HostSelectorTable.this.revalidate();
            i = 0;
            while (i < lists.length) {
                ((DefaultTableModel)HostSelectorTable.this.getModel()).addTableModelListener(lists[i]);
                ++i;
            }
        }
    }

    class TableMod
    extends DefaultTableModel {
        TableMod() {
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }
    }
}

