/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.hosts.HostSelector;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class HostSelectorList
extends JPanel
implements HostSelector {
    private static Logger logger = Logger.getLogger((String)HostSelectorList.class.getName());
    private JList jList;
    private HostList list;

    public HostSelectorList() {
        this.init();
    }

    public JList getJList() {
        return this.jList;
    }

    private void init() {
        try {
            this.jList = new JList();
            this.jList.getSelectionModel().setSelectionMode(0);
            this.setLayout(new GridLayout());
            this.list = HostList.getHostList();
            int numHosts = this.list.size();
            this.add(this.jList);
            String[] infos = new String[numHosts];
            int i = 0;
            while (i < numHosts) {
                infos[i] = this.list.getHostInfo(i).getName();
                ++i;
            }
            this.jList.setListData(infos);
            this.revalidate();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    @Override
    public HostInfo getSelectedHost() {
        return this.list.getHostInfo(this.getSelectedIndex());
    }

    @Override
    public HostList getListofHosts() {
        return this.list;
    }

    @Override
    public int getSelectedIndex() {
        return this.jList.getSelectedIndex();
    }

    @Override
    public void addHost(HostInfo hostInfo) {
        this.list.add(hostInfo);
        ((DefaultListModel)this.jList.getModel()).addElement(hostInfo);
    }

    @Override
    public void deleteSelectedHost() {
        int ind = this.jList.getSelectedIndex();
        this.list.remove(ind);
        ((DefaultListModel)this.jList.getModel()).remove(ind);
    }

    class CBPanel
    extends JPanel {
        CBPanel(int numhosts) {
            this.setLayout(new GridLayout(numhosts, 1));
            int i = 0;
            while (i < numhosts) {
                this.add(new JCheckBox(""));
                ++i;
            }
        }
    }

    class CheckListRenderer
    extends JCheckBox
    implements ListCellRenderer {
        public CheckListRenderer() {
            this.setBackground(UIManager.getColor("List.textBackground"));
            this.setForeground(UIManager.getColor("List.textForeground"));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            this.setEnabled(list.isEnabled());
            this.setSelected(((CheckableItem)value).isSelected());
            this.setFont(list.getFont());
            this.setText(value.toString());
            return this;
        }
    }

    class CheckableItem {
        private String str;
        private boolean isSelected;

        public CheckableItem(String str) {
            this.str = str;
            this.isSelected = false;
        }

        public void setSelected(boolean b) {
            this.isSelected = b;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public String toString() {
            return this.str;
        }
    }
}

