/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.PasswordManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class HostList
extends LinkedList {
    private static Logger logger = Logger.getLogger((String)HostList.class.getName());
    private static HostList list;
    private final String FS = ConstParameters.FS;
    private String hostsFile = String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer" + this.FS + "hosts.xml";
    private PasswordManager pass;

    public static HostList getHostList() {
        if (list == null) {
            list = new HostList();
        }
        return list;
    }

    public static String[] getHostNames() {
        HostList li = HostList.getHostList();
        String[] hosts = new String[li.size()];
        int i = 0;
        while (i < li.size()) {
            hosts[i] = li.getHostInfo(i).getName();
            ++i;
        }
        return hosts;
    }

    private HostList() {
        if (!new File(this.hostsFile).exists()) {
            this.createHostsFile();
        }
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.warn((Object)"can't manage password ...");
        }
        boolean foundLocalhost = false;
        Document document = XMLUtils.getDocumentFromFile(new File(this.hostsFile));
        Element rootElement = document.getRootElement();
        List list = rootElement.getChildren();
        int i = 0;
        while (i < list.size()) {
            Element ele = (Element)list.get(i);
            String nam = ele.getName();
            HostInfo inf = new HostInfo(nam);
            List children = ele.getChildren();
            int j = 0;
            while (j < children.size()) {
                Element child = (Element)children.get(j);
                String key = child.getName();
                String val = MyElement.decode(child.getTextTrim());
                inf.setProperty(key, val);
                ++j;
            }
            if (nam.trim().equals("localhost")) {
                this.addFirst(inf);
            } else {
                this.addLast(inf);
            }
            ++i;
        }
        try {
            this.readPasswordFile();
        }
        catch (IOException ioe) {
            logger.debug((Object)"couldn't read password files");
        }
    }

    private void createHostsFile() {
        String vendor;
        Document document = new Document();
        Element rootElement = new Element("hosts");
        Element localHost = new Element("localhost");
        Element address = new Element("address").setText(MyElement.encode("127.0.0.1"));
        Element userName = new Element("username").setText(MyElement.encode(System.getProperty("user.name")));
        Element bindir = new Element("bindir").setText(MyElement.encode(String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + "bin"));
        Element mpiDir = null;
        if (Utils.isWindows() && (vendor = System.getProperty("pviewer.vendor")) != null && vendor.equalsIgnoreCase("asms")) {
            mpiDir = new Element("mpidir").setText(MyElement.encode(String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + "mpi"));
        }
        Element basedir = new Element("basedir").setText(MyElement.encode(String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "phase-viewer-projects"));
        Element isdefault = new Element("default").setText(MyElement.encode("true"));
        localHost.addContent((Content)address);
        localHost.addContent((Content)userName);
        localHost.addContent((Content)bindir);
        localHost.addContent((Content)basedir);
        localHost.addContent((Content)isdefault);
        if (mpiDir != null) {
            localHost.addContent((Content)mpiDir);
        }
        rootElement.addContent((Content)localHost);
        document.setRootElement(rootElement);
        XMLUtils.saveDocumentTo(document, this.hostsFile);
    }

    public HostInfo getDefaultHost() {
        int i = 0;
        while (i < this.size()) {
            String foo = this.getHostInfo(i).getProperty("default");
            if (foo != null && foo.equalsIgnoreCase("true")) {
                return this.getHostInfo(i);
            }
            ++i;
        }
        return this.getHostInfo("localhost");
    }

    public HostInfo getHostInfo(int i) {
        HostInfo info;
        if (i == -1) {
            return null;
        }
        try {
            info = (HostInfo)this.get(i);
        }
        catch (Exception e) {
            logger.warn((Object)("failed to get HostInfo at: " + i));
            return null;
        }
        return info;
    }

    public HostInfo getHostInfo(String hostName) {
        int i = 0;
        while (i < this.size()) {
            HostInfo hinfo = this.getHostInfo(i);
            if (hinfo.getName().equals(hostName)) {
                return hinfo;
            }
            ++i;
        }
        return null;
    }

    public HostInfo getHostInfoFromAddress(String address) {
        int i = 0;
        while (i < this.size()) {
            HostInfo hinfo = this.getHostInfo(i);
            TaggedString[] ts = hinfo.getHostProperties();
            if (ts != null && ts.length != 0) {
                int j = 0;
                while (j < ts.length) {
                    if (ts[j].getTag().equals("address") && ts[j].getValue().equals(address)) {
                        return hinfo;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    protected void debug() {
        int i = 0;
        while (i < this.size()) {
            logger.debug((Object)("for HostInfo " + i));
            this.getHostInfo(i).debug();
            ++i;
        }
    }

    public void save() {
        Document document = XMLUtils.getDocumentFromFile(new File(this.hostsFile));
        if (document == null) {
            this.createHostsFile();
            document = XMLUtils.getDocumentFromFile(new File(this.hostsFile));
        }
        Element rootElement = document.getRootElement();
        List list = rootElement.getChildren();
        int i = 0;
        while (i < list.size()) {
            Element el = (Element)list.get(i);
            boolean valid = false;
            int j = 0;
            while (j < this.size()) {
                if (this.getHostInfo(j).getName().equals(el.getName())) {
                    valid = true;
                }
                ++j;
            }
            if (!valid) {
                rootElement.removeContent((Content)el);
            }
            ++i;
        }
        i = 0;
        while (i < this.size()) {
            HostInfo info = this.getHostInfo(i);
            String name = info.getName();
            Element elemHost = rootElement.getChild(name);
            if (elemHost == null) {
                elemHost = new Element(name);
                rootElement.addContent((Content)elemHost);
            }
            logger.debug((Object)("host: " + elemHost.getName()));
            TaggedString[] props = info.getHostProperties();
            int j = 0;
            while (j < props.length) {
                String key = props[j].getTag();
                String val = props[j].getValue();
                Element child = elemHost.getChild(key);
                if (child == null) {
                    child = new Element(key);
                    elemHost.addContent((Content)child);
                }
                child.setText(MyElement.encode(val));
                logger.debug((Object)("hostinfo: " + key + ", " + val));
                ++j;
            }
            ++i;
        }
        XMLUtils.saveDocumentTo(document, this.hostsFile);
        Vector<TaggedString> passVector = new Vector<TaggedString>();
        Vector<String> rempassVector = new Vector<String>();
        int i2 = 0;
        while (i2 < this.size()) {
            String name;
            HostInfo info = this.getHostInfo(i2);
            String ssavepass = info.getProperty("savepass");
            boolean savepass = false;
            if (ssavepass != null && ssavepass.equalsIgnoreCase("true")) {
                savepass = true;
            }
            if (savepass) {
                name = info.getName();
                String passString = info.getPasswordString();
                passVector.addElement(new TaggedString(name, passString));
            } else {
                name = info.getName();
                rempassVector.addElement(name);
            }
            ++i2;
        }
        if (passVector.size() >= 1) {
            try {
                this.writePasswordFile(passVector);
            }
            catch (IOException ioe) {
                logger.error((Object)"failed to save encrypted passwords to disk");
            }
        }
        if (rempassVector.size() >= 1) {
            String passwordDir = String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer" + this.FS + "passwords";
            int ii = 0;
            while (ii < rempassVector.size()) {
                new File(String.valueOf(passwordDir) + this.FS + (String)rempassVector.elementAt(ii)).delete();
                ++ii;
            }
        }
    }

    protected void writePasswordFile(Vector passVector) throws IOException {
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error((Object)"failed to create password manager");
            return;
        }
        String passwordDir = String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer" + this.FS + "passwords";
        new File(passwordDir).mkdir();
        int i = 0;
        while (i < passVector.size()) {
            block6: {
                TaggedString data = (TaggedString)passVector.get(i);
                String name = data.getTag().trim();
                String passwd = data.getValue().trim();
                byte[] passb = null;
                try {
                    passb = this.pass.getEncryptedPassword(passwd);
                }
                catch (Exception exc) {
                    logger.error((Object)"failed to encrypt password");
                    break block6;
                }
                if (passb != null) {
                    BufferedOutputStream bostream = new BufferedOutputStream(new FileOutputStream(String.valueOf(passwordDir) + this.FS + name));
                    bostream.write(passb, 0, passb.length);
                    bostream.flush();
                }
            }
            ++i;
        }
    }

    protected void readPasswordFile() throws IOException {
        File passwdDir = new File(String.valueOf(System.getProperty("user.home")) + this.FS + ".phase-viewer" + this.FS + "passwords");
        if (!passwdDir.exists()) {
            return;
        }
        File[] passwdFiles = passwdDir.listFiles();
        try {
            this.pass = new PasswordManager();
        }
        catch (Exception exc) {
            logger.error((Object)exc);
            logger.warn((Object)"can't manage password ...");
            return;
        }
        int i = 0;
        while (i < passwdFiles.length) {
            block8: {
                String name = passwdFiles[i].getName();
                BufferedInputStream bistream = new BufferedInputStream(new FileInputStream(String.valueOf(passwdDir.getAbsolutePath()) + this.FS + name));
                byte[] pas = new byte[bistream.available()];
                bistream.read(pas);
                String planepass = "";
                try {
                    planepass = this.pass.getPlanePassword(pas);
                    logger.debug((Object)("plain password: " + planepass));
                }
                catch (Exception exc) {
                    logger.debug((Object)"couldn't get plain password...");
                    break block8;
                }
                int j = 0;
                while (j < this.size()) {
                    HostInfo info = this.getHostInfo(j);
                    if (info.getName().trim().equals(name)) {
                        info.setPasswordString(planepass);
                        info.setSavePassword(true);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

