/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.ssh.hosts.HostConfigEditors;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.hosts.HostSelector;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

class CaretListenerHostConfigurator
implements CaretListener {
    private static Logger logger = Logger.getLogger((String)CaretListenerHostConfigurator.class.getName());
    private HostSelector parent;
    private HostList list;
    private String tag;

    protected CaretListenerHostConfigurator(HostSelector parent) {
        this.parent = parent;
        this.list = parent.getListofHosts();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        HostConfigEditors editor = (HostConfigEditors)e.getSource();
        int selected = this.parent.getSelectedIndex();
        if (selected < 0) {
            return;
        }
        HostInfo info = this.list.getHostInfo(selected);
        String type = editor.getPropertyType();
        String value = editor.getValue();
        if (type.equals("password")) {
            info.setPasswordString(value);
        } else {
            info.setProperty(type, value);
        }
        logger.debug((Object)("updated host info no. " + selected));
        logger.debug((Object)("value is: " + value));
    }
}

