/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.settings;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.settings.ACVProperties;
import ciss.phase_viewer.settings.ChaseProperties;
import ciss.phase_viewer.settings.ElementProperties;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.InstallationProperties;
import ciss.phase_viewer.settings.LastUsedDirProperties;
import ciss.phase_viewer.settings.SizeProperties;
import ciss.phase_viewer.settings.WindowProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class PropertiesManager {
    public static final int PROPERTIES_PVIEWER = 0;
    public static final int PROPERTIES_ACV = 1;
    public static final int PROPERTIES_SIZE = 2;
    public static final int PROPERTIES_ELEMINFO = 3;
    public static final int PROPERTIES_INSTALLATION = 4;
    public static final int PROPERTIES_LAST_USED_DIR = 5;
    public static final int PROPERTIES_WINDOW = 6;
    private static InstallationProperties installation;
    private static GlobalProperties Chase;
    private static GlobalProperties ACV;
    private static GlobalProperties Size;
    private static GlobalProperties Element;
    private static GlobalProperties Last_used_dir;
    private static GlobalProperties windows;
    private static Logger logger;

    static {
        logger = Logger.getLogger((String)PropertiesManager.class.getName());
    }

    public static GlobalProperties getGlobalProperties(int propertyType) {
        if (installation == null) {
            installation = new InstallationProperties();
        }
        if (propertyType == 4) {
            return installation;
        }
        if (propertyType == 0) {
            if (Chase == null) {
                String FS = System.getProperty("file.separator");
                File defaultChaseini = new File(String.valueOf(System.getProperty("pviewer.home")) + FS + "install" + FS + "install_files" + FS + "phase-viewer.ini");
                Properties props = new Properties();
                try {
                    props.load(new FileInputStream(defaultChaseini));
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                Chase = new ChaseProperties(installation, props);
            }
            return Chase;
        }
        if (propertyType == 1) {
            if (ACV == null) {
                InputStream inStream = GlobalProperties.class.getResourceAsStream("/ciss/phase_viewer/settings/acvconfig.properties");
                if (System.getProperty("os.name").startsWith("Linux") || Utils.parseJREVersion() >= 170) {
                    inStream = GlobalProperties.class.getResourceAsStream("/ciss/phase_viewer/settings/acvconfig_linux.properties");
                }
                Properties props = new Properties();
                try {
                    props.load(inStream);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                ACV = new ACVProperties(installation, props);
            }
            return ACV;
        }
        if (propertyType == 2) {
            if (Size == null) {
                Size = new SizeProperties(installation);
            }
            return Size;
        }
        if (propertyType == 3) {
            if (Element == null) {
                Element = new ElementProperties(installation);
            }
            return Element;
        }
        if (propertyType == 5) {
            if (Last_used_dir == null) {
                Last_used_dir = new LastUsedDirProperties(installation);
            }
            return Last_used_dir;
        }
        if (propertyType == 6) {
            if (windows == null) {
                windows = new WindowProperties(installation);
            }
            return windows;
        }
        logger.debug((Object)"wrong property type");
        return null;
    }
}

