/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptmanipulator;

import ciss.phase_viewer.scripting.ScriptDescriptionPanel;
import ciss.phase_viewer.scripting.ScriptUtils;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorCaller;
import ciss.phase_viewer.scripting.scripteditor.ScriptEditorGUI;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ScriptList
extends JPanel
implements ListSelectionListener,
MouseListener,
KeyListener,
ScriptEditorCaller {
    private Logger logger = Logger.getLogger((String)ScriptList.class.getName());
    private HashMap map = new HashMap();
    private JList jlist;
    private ScriptDescriptionPanel descriptionPanel;
    private String scriptType = ScriptWrapper.SH;
    private JSplitPane pane;

    public ScriptList() {
        this.setLayout(new GridLayout());
        DefaultListModel model = new DefaultListModel();
        this.jlist = new JList();
        this.jlist.setSelectionMode(0);
        this.jlist.addListSelectionListener(this);
        JScrollPane scr = new JScrollPane();
        scr.getViewport().setView(this.jlist);
        this.descriptionPanel = new ScriptDescriptionPanel();
        this.pane = new JSplitPane(1, true, scr, this.descriptionPanel);
        this.pane.setResizeWeight(0.5);
        this.add(this.pane);
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.scriptType = ScriptWrapper.BAT;
        }
        this.jlist.addMouseListener(this);
        this.jlist.addKeyListener(this);
        this.mousePressed(null);
    }

    public ScriptList(ScriptWrapper[] initScript) {
        this();
        this.scriptType = this.scriptType;
        if (initScript != null) {
            int i = 0;
            while (i < initScript.length) {
                this.addScriptToMap(initScript[i]);
                ++i;
            }
        }
        this.updateGUI();
        this.jlist.setSelectedIndex(0);
    }

    public void adjust() {
        this.pane.setDividerLocation(0.5);
    }

    public ScriptList(ScriptWrapper[] initScript, String scriptType) {
        this(initScript);
        this.scriptType = scriptType;
        this.updateGUI();
        this.jlist.setSelectedIndex(0);
    }

    private void addScriptToMap(ScriptWrapper script) {
        DefaultListModel<ScriptWrapper> model = (DefaultListModel<ScriptWrapper>)this.map.get(script.getScriptType());
        if (model == null) {
            model = new DefaultListModel<ScriptWrapper>();
            this.map.put(script.getScriptType(), model);
        }
        model.addElement(script);
    }

    private void removeScriptFromMap(ScriptWrapper script) {
        DefaultListModel model = (DefaultListModel)this.map.get(script.getScriptType());
        if (model == null) {
            return;
        }
        model.removeElement(script);
    }

    public void addScript(ScriptWrapper script) {
        this.logger.debug((Object)("adding script: " + script));
        this.addScriptToMap(script);
        this.updateGUI();
    }

    public void removeScript(ScriptWrapper script) {
        this.removeScriptFromMap(script);
        this.updateGUI();
    }

    public void setScriptType(String scriptType) {
        this.scriptType = scriptType;
        this.updateGUI();
    }

    public void shiftDownSelectedElement() {
        DefaultListModel model;
        int index = this.jlist.getSelectedIndex();
        if (index == (model = (DefaultListModel)this.map.get(this.scriptType)).size() - 1) {
            return;
        }
        Object orig = model.get(index);
        Object down = model.get(index + 1);
        model.set(index, down);
        model.set(index + 1, orig);
        this.setModelToList();
        this.jlist.setSelectedIndex(index + 1);
    }

    public void shiftUpSelectedElement() {
        int index = this.jlist.getSelectedIndex();
        if (index == 0) {
            return;
        }
        DefaultListModel model = (DefaultListModel)this.map.get(this.scriptType);
        Object orig = model.get(index);
        Object up = model.get(index - 1);
        model.set(index, up);
        model.set(index - 1, orig);
        this.setModelToList();
        this.jlist.setSelectedIndex(index - 1);
    }

    public void deleteSelectedElement() {
        int remind;
        DefaultListModel model = (DefaultListModel)this.map.get(this.scriptType);
        Object o = model.remove(remind = this.jlist.getSelectedIndex());
        if (o instanceof ScriptWrapper) {
            String path = ((ScriptWrapper)o).getPath();
            ScriptUtils.removeNecessaryFiles(path, new File(path).getParent());
            new File(path).delete();
        }
        this.setModelToList();
        this.revalidate();
        if (remind >= model.size() - 1) {
            this.jlist.setSelectedIndex(remind - 1);
        } else {
            this.jlist.setSelectedIndex(remind);
        }
    }

    public ScriptWrapper[] getAllScripts() {
        Vector ret = new Vector();
        Collection collection = this.map.values();
        Object[] model = collection.toArray();
        if (model == null) {
            return null;
        }
        int i = 0;
        while (i < model.length) {
            DefaultListModel md = (DefaultListModel)model[i];
            int j = 0;
            while (j < md.size()) {
                ret.addElement(md.getElementAt(j));
                ++j;
            }
            ++i;
        }
        if (ret == null || ret.size() == 0) {
            return null;
        }
        Object[] scripts = new ScriptWrapper[ret.size()];
        ret.copyInto(scripts);
        return scripts;
    }

    public int getNumScripts() {
        return ((DefaultListModel)this.jlist.getModel()).size();
    }

    public ScriptWrapper getScriptAt(int i) {
        DefaultListModel model = (DefaultListModel)this.jlist.getModel();
        ScriptWrapper ret = (ScriptWrapper)model.elementAt(i);
        return ret;
    }

    public ScriptWrapper getSelectedScript() {
        ScriptWrapper ret = (ScriptWrapper)this.jlist.getSelectedValue();
        return ret;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ScriptWrapper scr = (ScriptWrapper)this.jlist.getSelectedValue();
        if (scr == null) {
            return;
        }
        this.descriptionPanel.setScriptFile(scr.getPath());
        this.revalidate();
    }

    public void setDescription(String scriptPath) {
        this.descriptionPanel.setScriptFile(scriptPath);
    }

    private void updateGUI() {
        this.setModelToList();
        this.revalidate();
    }

    private void setModelToList() {
        DefaultListModel model = (DefaultListModel)this.map.get(this.scriptType);
        if (model == null) {
            model = new DefaultListModel();
            this.map.put(this.scriptType, model);
        }
        this.jlist.setModel(model);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.bootEditor();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.adjust();
        if (e == null) {
            return;
        }
        if (e.getButton() == 1) {
            ScriptWrapper scr = (ScriptWrapper)this.jlist.getSelectedValue();
            if (scr == null) {
                return;
            }
            this.descriptionPanel.setScriptFile(scr.getPath());
            this.revalidate();
        }
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            this.bootEditor();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    public void bootEditor() {
        ScriptEditorGUI editor = new ScriptEditorGUI(this);
    }

    @Override
    public String getScriptPath() {
        ScriptWrapper scr = this.getSelectedScript();
        if (scr != null) {
            return scr.getPath();
        }
        return "";
    }

    @Override
    public HashMap getObjects() {
        return null;
    }
}

