/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptexecscripts;

import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.scripting.ScriptWrapper;
import ciss.phase_viewer.scripting.scriptexecscripts.ScriptExecScript;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ExecScriptCreator {
    private static Logger logger = Logger.getLogger((String)ExecScriptCreator.class.getName());

    private ExecScriptCreator() {
    }

    public static String getScriptExecScript(String scriptType, ScriptWrapper[] execScripts, HostInfo hostInfo) {
        if (execScripts == null || execScripts.length == 0) {
            logger.error((Object)"no exec scripts.");
            return "";
        }
        String[] string = new String[execScripts.length];
        int i = 0;
        while (i < execScripts.length) {
            string[i] = new File(execScripts[i].getPath()).getName();
            ++i;
        }
        String ret = ExecScriptCreator.getScriptExecScript(scriptType, string, hostInfo);
        return ret;
    }

    public static String getScriptExecScript(String scriptType, String[] execScripts, HostInfo hostInfo) {
        if (execScripts == null || execScripts.length == 0) {
            logger.error((Object)"no exec scripts.");
            return "";
        }
        ScriptExecScript execscript = ExecScriptCreator.getScriptExecScriptSub(scriptType);
        if (execscript == null) {
            logger.error((Object)"failed to get exec script creator.");
            return "";
        }
        String file = System.getProperty("java.io.tmpdir");
        if (!file.endsWith(System.getProperty("file.separator"))) {
            file = String.valueOf(file) + System.getProperty("file.separator");
        }
        file = String.valueOf(file) + execscript.getScriptExecScriptName(hostInfo);
        String script = execscript.createScriptExecScript(execScripts, hostInfo);
        BufferedWriter bwriter = null;
        try {
            try {
                new File(file).delete();
                bwriter = new BufferedWriter(new FileWriter(file));
                bwriter.write(script, 0, script.length());
                bwriter.flush();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    bwriter.close();
                }
                catch (IOException ioe2) {
                    ioe2.printStackTrace();
                }
            }
        }
        finally {
            try {
                bwriter.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        return file;
    }

    public static String getScriptExecScriptExecString(String scriptType, String scriptExecScript, HostInfo hostInfo) {
        ScriptExecScript execscript = ExecScriptCreator.getScriptExecScriptSub(scriptType);
        return execscript.getScriptExecScriptExecString(scriptExecScript, hostInfo);
    }

    private static ScriptExecScript getScriptExecScriptSub(String scriptType) {
        Properties props;
        block15: {
            boolean registered = false;
            int i = 0;
            while (i < ScriptWrapper.REGISTERED_SCRIPT_TYPE.length) {
                if (scriptType.equals(ScriptWrapper.REGISTERED_SCRIPT_TYPE[i])) {
                    registered = true;
                    break;
                }
                ++i;
            }
            if (!registered) {
                logger.error((Object)"unsupported script type!");
                return null;
            }
            props = new Properties();
            InputStream inp = null;
            try {
                try {
                    inp = ExecScriptCreator.class.getResourceAsStream("/ciss/phase_viewer/scripting/scriptexecscripts/scriptexecscripts.properties");
                    props.load(inp);
                }
                catch (IOException ioe) {
                    logger.error((Object)"failed to load property file...");
                    try {
                        inp.close();
                    }
                    catch (IOException ioe2) {
                        ioe2.printStackTrace();
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    inp.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                throw throwable;
            }
            try {
                inp.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        String loadClass = props.getProperty(scriptType);
        if (loadClass == null || loadClass.trim().length() == 0) {
            logger.error((Object)"invalid properties file...");
            return null;
        }
        ScriptExecScript execscript = (ScriptExecScript)PluginLoader.instantiate(loadClass, null);
        return execscript;
    }
}

