/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectstatemanipulator;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeEvent;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeListener;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChanger;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ProjectRemover
extends InternalFrameChase
implements ProjectStateChanger {
    private Logger logger = Logger.getLogger((String)ProjectRemover.class.getName());
    private JCheckBox removeFiles;
    private ProjectDirBrowserNode node;
    private Vector listeners = new Vector();
    private ProjectDirBrowser dirBrowser;

    public ProjectRemover(String title, ProjectDirBrowserNode node, ProjectDirBrowser dirBrowser) {
        super(title, false, false, false, false, new Dimension(300, 120));
        this.node = node;
        this.dirBrowser = dirBrowser;
        this.init();
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener listener) {
        this.listeners.addElement(listener);
    }

    private void init() {
        Container cont = this.getContentPane();
        JPanel p = new JPanel();
        p.setLayout(new GridLayout(2, 1));
        p.add(this.removeFilesTooPanel());
        p.add(this.buttonPanel());
        cont.add(p);
    }

    private JPanel removeFilesTooPanel() {
        JPanel p = new JPanel();
        p.setLayout(new FlowLayout());
        this.removeFiles = new JCheckBox("remove files and directories too");
        p.add(this.removeFiles);
        return p;
    }

    private JPanel buttonPanel() {
        JPanel p = new JPanel();
        JButton ok = new JButton("ok");
        JButton can = new JButton("cancel");
        can.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectRemover.this.dispose();
            }
        });
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProjectRemover.this.manipulateProjectState();
                ProjectRemover.this.dispose();
            }
        });
        p.add(ok);
        p.add(can);
        return p;
    }

    @Override
    public void manipulateProjectState() {
        ProjectInfo info;
        String dir;
        boolean b;
        if (this.removeFiles.isSelected() && !(b = Utils.deleteDir(new File(dir = (info = this.node.getProjectInfo()).getProjectDirectory())))) {
            this.logger.error((Object)("failed to delete directory: " + dir));
            return;
        }
        this.dirBrowser.removeCurrentNode();
        if (this.node.getProjectBrowser() != null && this.node.getProjectBrowser().isVisible()) {
            this.node.getProjectBrowser().dispose();
        }
        this.notifyListeners();
        this.logger.info((Object)"removed project.");
    }

    private void notifyListeners() {
        int i = 0;
        while (i < this.listeners.size()) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener)this.listeners.elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this));
            ++i;
        }
    }
}

