/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import java.util.EventObject;
import javax.swing.JTextField;
import javax.swing.event.CaretListener;
import org.apache.log4j.Logger;

public class TextFieldPhase
extends JTextField
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger((String)TextFieldPhase.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private boolean isDoubleQuoted = false;

    public TextFieldPhase(int columns, String[] inputSpecifications, InputInterface inputinterface, boolean isDoubleQuoted) {
        super(columns);
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.isDoubleQuoted = isDoubleQuoted;
        inputinterface.addInputInterfaceEntryChangeListener(this);
        logger.debug((Object)("inputSpec: " + inputSpecifications[0] + " is DQ? " + this.isDoubleQuoted));
    }

    @Override
    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        String inp = this.inputSpecifications[0];
        InputInterfacePrimitiveEntry entry = this.inputinterface.getInputInterfacePrimitiveEntry(inp);
        String[] fname = inp.split("\\.");
        String name = fname[fname.length - 1];
        String value = super.getText().trim();
        entry.saveState();
        entry.setName(name);
        entry.setValue(value);
        entry.setDoubleQuoted(this.isDoubleQuoted);
        logger.debug((Object)(" primitive entry: " + entry));
        if (value.length() == 0) {
            this.inputinterface.removeEntry(entry, this);
        } else {
            this.inputinterface.replaceEntry(entry, this);
        }
    }

    @Override
    public void inputInterfaceInitialized() {
    }

    @Override
    public void inputInterfaceInitializing() {
        CaretListener[] lists = this.getCaretListeners();
        int i = 0;
        while (i < lists.length) {
            this.removeCaretListener(lists[i]);
            ++i;
        }
        this.setText("");
        i = 0;
        while (i < lists.length) {
            this.addCaretListener(lists[i]);
            ++i;
        }
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        logger.debug((Object)("at inputInterfaceEntryChanged... evt.getTag(): " + evt.getTag()));
        if (evt.getSource() == this) {
            return;
        }
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 0) {
            return;
        }
        InputInterfacePrimitiveEntry pentry = (InputInterfacePrimitiveEntry)entry;
        String fullName = String.valueOf(tag) + "." + pentry.getName();
        logger.debug((Object)("caught change of inputinterface object at: " + fullName + " and I'm " + this.inputSpecifications[0]));
        logger.debug((Object)("specifically, the change is : " + pentry.getValue()));
        CaretListener[] listeners = this.getCaretListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeCaretListener(listeners[i]);
            ++i;
        }
        i = 0;
        while (i < this.inputSpecifications.length) {
            if (fullName.trim().equalsIgnoreCase(this.inputSpecifications[i].trim())) {
                this.setText(pentry.getValue());
                break;
            }
            ++i;
        }
        i = 0;
        while (i < listeners.length) {
            this.addCaretListener(listeners[i]);
            ++i;
        }
    }
}

