/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.ComboBoxPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.PrimitiveInputComponents;
import ciss.phase_viewer.primitiveguis.TextFieldPhase;
import java.awt.event.ActionListener;
import java.util.EventListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class InputPanelPhase
extends PrimitiveInputComponents
implements PhaseInputPanelInterface {
    private static Logger logger = Logger.getLogger((String)InputPanelPhase.class.getName());
    private TextFieldPhase textfield;
    private ComboBoxPhase combobox;
    private String title;
    private int unit;
    private int columns;
    public static final int NONE = 0;
    public static final int LONGTIME = 1;
    public static final int TIME = 2;
    public static final int LENGTH = 3;
    public static final int ENERGY = 4;
    public static final int FORCE = 5;
    public static final int ANGLE = 6;
    private String[] choices;
    private String[] units_longtime = new String[]{"sec", "day", "hour", "min"};
    private String[] units_time = new String[]{"au_time", "fs", "ns"};
    private String[] units_length = new String[]{"Bohr", "Angstrom", "nm"};
    private String[] units_energy = new String[]{"Hartree", "Rydberg", "eV"};
    private String[] units_force = new String[]{"Hartree/Bohr", "eV/Angstrom"};
    private String[] units_angle = new String[]{"degree", "radian"};

    public InputPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, int unit, int columns, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.unit = unit;
        this.columns = columns;
        logger.debug((Object)(" from constructor 1 of ippphase.... inputSpec: " + inputSpecifications[0] + " isDQ? " + this.isDoubleQuoted));
        this.createGUI();
        this.addListeners(parent);
    }

    public InputPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, int unit, int columns, EventListener parent, boolean isDoubleQuoted) {
        super(inputSpecifications, inputinterface, isDoubleQuoted);
        this.title = title;
        this.unit = unit;
        this.columns = columns;
        logger.debug((Object)(" from constructor 2 of ippphase.... inputSpec: " + inputSpecifications[0] + " isDQ? " + isDoubleQuoted));
        this.createGUI();
        this.addListeners(parent);
    }

    public InputPanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, int unit, int columns) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.unit = unit;
        this.columns = columns;
        logger.debug((Object)(" from constructor 3 of ippphase.... inputSpec: " + inputSpecifications[0] + " isDQ? " + this.isDoubleQuoted));
        this.createGUI();
    }

    @Override
    public void addListeners(EventListener listener) {
        if (this.combobox != null) {
            if (listener instanceof ActionListener) {
                this.combobox.addActionListener((ActionListener)listener);
            }
            if (listener instanceof PopupMenuListener) {
                this.combobox.addPopupMenuListener((PopupMenuListener)listener);
            }
        }
        if (listener instanceof CaretListener) {
            this.textfield.addCaretListener((CaretListener)listener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.combobox != null) {
            this.combobox.setEnabled(enabled);
        }
        this.textfield.setEditable(enabled);
    }

    private void createGUI() {
        int pwidth = this.unit == 0 ? this.columns : this.columns + 80;
        if (this.unit == 1) {
            this.choices = this.units_longtime;
        } else if (this.unit == 2) {
            this.choices = this.units_time;
        } else if (this.unit == 3) {
            this.choices = this.units_length;
        } else if (this.unit == 4) {
            this.choices = this.units_energy;
        } else if (this.unit == 5) {
            this.choices = this.units_force;
        } else if (this.unit == 6) {
            this.choices = this.units_angle;
        }
        this.createTextField();
        super.add(this.textfield);
        if (this.unit != 0) {
            this.createComboBox();
            this.combobox.setSize(60, 20);
            this.add(this.combobox);
            this.combobox.setSelectedIndex(this.combobox.getSelectedIndex());
        }
        super.setLayout(new BoxLayout(this, 0));
        super.setSize(pwidth, 20);
        if (this.title != null) {
            super.setBorder(new TitledBorder(this.title));
        }
    }

    private void createTextField() {
        this.textfield = new TextFieldPhase(this.columns, this.inputSpecifications, this.inputInterface, this.isDoubleQuoted);
        String val = this.entry.getValue();
        logger.debug((Object)("value: " + val));
        this.textfield.setText(val);
    }

    private void createComboBox() {
        this.combobox = new ComboBoxPhase(this.choices, this.inputSpecifications, this.inputInterface, true);
        String unit = this.entry.getUnit();
        int i = 0;
        while (i < this.choices.length) {
            if (this.choices[i].equalsIgnoreCase(unit)) {
                this.combobox.setSelectedIndex(i);
            }
            ++i;
        }
        this.textfield.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                InputPanelPhase.this.combobox.silentUpdate();
            }
        });
    }

    @Override
    public String getValue() {
        return this.textfield.getText();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }

    @Override
    public String getUnit() {
        return (String)this.combobox.getSelectedItem();
    }

    public TextFieldPhase getTextField() {
        return this.textfield;
    }
}

