/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.primitiveguis.ComboBoxPhase;
import ciss.phase_viewer.primitiveguis.PhaseInputPanelInterface;
import ciss.phase_viewer.primitiveguis.PrimitiveInputComponents;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.TitledBorder;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;

public class ChoicePanelPhase
extends PrimitiveInputComponents
implements PhaseInputPanelInterface {
    private ComboBoxPhase combobox;
    public static String NO_SELECTION = ConstParameters.NO_SELECTION;
    private static Logger logger = Logger.getLogger((String)ChoicePanelPhase.class.getName());
    private String[] choices;
    private String[] fullName;
    private String title;
    private Vector dupli = null;

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli, EventListener parent) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.createGUI();
        this.addListeners(parent);
    }

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.createGUI();
    }

    public ChoicePanelPhase(String[] inputSpecifications, InputInterface inputinterface, String title, String[] choices, Vector dupli) {
        super(inputSpecifications, inputinterface);
        this.title = title;
        this.choices = choices;
        this.dupli = dupli;
        this.createGUI();
    }

    public void setToolTips(String[] tips) {
        if (this.combobox != null) {
            this.combobox.setToolTips(tips);
        }
    }

    private void createGUI() {
        super.setLayout(new BoxLayout(this, 0));
        this.createComboBox();
        super.add(this.combobox);
        if (this.title != null) {
            super.setBorder(new TitledBorder(this.title));
        }
    }

    private void createComboBox() {
        this.combobox = new ComboBoxPhase(this.choices, this.inputSpecifications, this.inputInterface, false);
        String value = this.entry.getValue().trim();
        int i = 0;
        while (i < this.choices.length) {
            logger.debug((Object)("choice at: " + i + " is " + this.choices[i]));
            if (this.choices[i].equalsIgnoreCase(value)) {
                this.combobox.setSelectedIndex(i);
            }
            ++i;
        }
        if (this.dupli != null) {
            i = 0;
            while (i < this.dupli.size()) {
                String[] d = (String[])this.dupli.get(i);
                int index = Integer.parseInt(d[0]);
                String newval = d[1];
                if (newval.equalsIgnoreCase(value)) {
                    this.combobox.setSelectedIndex(index);
                }
                ++i;
            }
        }
    }

    @Override
    public void addListeners(EventListener listener) {
        if (listener instanceof ActionListener) {
            this.combobox.addActionListener((ActionListener)listener);
        }
        if (listener instanceof PopupMenuListener) {
            this.combobox.addPopupMenuListener((PopupMenuListener)listener);
        }
    }

    public void registerDisabableGUI(int[] index, JComponent jcomponent) {
        this.combobox.removeListeners();
        this.combobox.setDisabableGUI(index, jcomponent);
        this.combobox.disableRegisteredGUI();
        this.combobox.restoreListeners();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.combobox.setEnabled(enabled);
    }

    @Override
    public String getValue() {
        return (String)this.combobox.getSelectedItem();
    }

    @Override
    public String getUnit() {
        return new String();
    }

    public JComboBox getComboBox() {
        return this.combobox;
    }
}

