/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.view;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class Rotator
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)Rotator.class.getName());
    private J3DPanel parent;
    private JTextField value;
    private JComboBox axis;

    public Rotator(J3DPanel parent) {
        super("rotate view", new Dimension(350, 150));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        this.init();
        this.setVisible(true);
    }

    private void init() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        String[] xyz = new String[]{"   x-axis   ", "   y-axis   ", "   z-axis   "};
        this.axis = new JComboBox<String>(xyz);
        JPanel paxis = new JPanel();
        paxis.setBorder(new TitledBorder("select axis"));
        paxis.add(this.axis);
        this.value = new JTextField(10);
        JPanel textpanel = new JPanel();
        textpanel.add(this.value);
        textpanel.setBorder(new TitledBorder("enter value"));
        JButton draw = new JButton("rotate");
        panel.add(paxis);
        panel.add(textpanel);
        panel.add(draw);
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton ok = new JButton("ok");
        buttons.add(ok);
        Container cont = super.getContentPane();
        cont.setLayout(new BoxLayout(cont, 1));
        cont.add(panel);
        cont.add(buttons);
        draw.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rotator.this.rotateView();
            }
        });
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Rotator.this.dispose();
            }
        });
    }

    private void rotateView() {
        double angle = 0.0;
        String sangle = this.value.getText();
        try {
            angle = Double.parseDouble(sangle);
        }
        catch (NumberFormatException nfe) {
            angle = 0.0;
        }
        int selectedAxis = this.axis.getSelectedIndex();
        Transform3D rot = new Transform3D();
        double ang_in_rad = angle * Math.PI / 180.0;
        if (selectedAxis == 0) {
            rot.rotX(ang_in_rad);
        } else if (selectedAxis == 1) {
            rot.rotY(ang_in_rad);
        } else if (selectedAxis == 2) {
            rot.rotZ(ang_in_rad);
        }
        TransformGroup[] tgs = this.parent.getRotatingTransform();
        int i = 0;
        while (i < tgs.length) {
            Transform3D at = new Transform3D();
            tgs[i].getTransform(at);
            at.mul(rot);
            tgs[i].setTransform(at);
            ++i;
        }
    }
}

