/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.prefs;

import ciss.phase_viewer.acviewer.BaseJ3DPanel;
import ciss.phase_viewer.acviewer.scenegraphelements.LightObject;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.media.j3d.BranchGroup;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class LightEditor
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)LightEditor.class.getName());
    private BaseJ3DPanel parent;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private Vector lightSourceEditors = new Vector();
    private int numlights = 5;

    public LightEditor(BaseJ3DPanel parent) {
        super("edit light source", true, true, true, true, new Dimension(625, 520));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        this.init();
        this.setVisible(true);
    }

    private void init() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel peditors = new JPanel();
        peditors.setLayout(new BoxLayout(peditors, 1));
        int i = 0;
        while (i < this.numlights) {
            LightSourceEditor editor = new LightSourceEditor(i);
            peditors.add(editor);
            this.lightSourceEditors.addElement(editor);
            ++i;
        }
        JPanel btns = new JPanel();
        btns.setLayout(new BoxLayout(btns, 0));
        JButton save = new JButton("apply");
        JButton close = new JButton("close");
        btns.add(save);
        btns.add(close);
        JPanel b = new JPanel();
        b.add(btns);
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LightEditor.this.dispose();
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                int i = 0;
                while (i < LightEditor.this.lightSourceEditors.size()) {
                    ((LightSourceEditor)LightEditor.this.lightSourceEditors.elementAt(i)).save();
                    ++i;
                }
                LightEditor.this.gp.storeProperty();
                BranchGroup bg = LightEditor.this.parent.getRootBranch();
                int i2 = 0;
                while (i2 < bg.numChildren()) {
                    if (bg.getChild(i2) instanceof LightObject) {
                        ((LightObject)bg.getChild(i2)).recreate();
                        return;
                    }
                    ++i2;
                }
            }
        });
        container.add((Component)peditors, "Center");
        container.add((Component)b, "South");
    }

    class LightSourceEditor
    extends JPanel {
        private String[] types = new String[]{"off", "point", "directional", "ambient"};
        private JComboBox type;
        private JTextField posx;
        private JTextField posy;
        private JTextField posz;
        private JTextField dirx;
        private JTextField diry;
        private JTextField dirz;
        private JButton color;
        private int ID;

        LightSourceEditor(int ID) {
            this.ID = ID;
            this.init();
        }

        private void init() {
            GridBagConstraints gc = new GridBagConstraints();
            gc.weightx = 1.0;
            gc.weighty = 0.0;
            gc.fill = 2;
            gc.anchor = 10;
            this.type = new JComboBox<String>(this.types);
            JPanel ptype = new JPanel();
            ptype.setLayout(new GridBagLayout());
            ptype.setBorder(new TitledBorder("light " + String.valueOf(this.ID + 1)));
            ptype.add((Component)this.type, gc);
            JPanel ppos = new JPanel();
            ppos.setLayout(new GridLayout(1, 3));
            ppos.setBorder(new TitledBorder("position"));
            this.posx = new JTextField(5);
            this.posy = new JTextField(5);
            this.posz = new JTextField(5);
            JPanel pposx = new JPanel();
            pposx.setBorder(new TitledBorder("x"));
            JPanel pposy = new JPanel();
            pposy.setBorder(new TitledBorder("y"));
            JPanel pposz = new JPanel();
            pposz.setBorder(new TitledBorder("z"));
            pposx.add(this.posx);
            pposy.add(this.posy);
            pposz.add(this.posz);
            ppos.add(pposx);
            ppos.add(pposy);
            ppos.add(pposz);
            JPanel pdir = new JPanel();
            pdir.setLayout(new GridLayout(1, 3));
            pdir.setBorder(new TitledBorder("direction"));
            this.dirx = new JTextField(5);
            this.diry = new JTextField(5);
            this.dirz = new JTextField(5);
            JPanel pdirx = new JPanel();
            pdirx.setBorder(new TitledBorder("x"));
            JPanel pdiry = new JPanel();
            pdiry.setBorder(new TitledBorder("y"));
            JPanel pdirz = new JPanel();
            pdirz.setBorder(new TitledBorder("z"));
            pdirx.add(this.dirx);
            pdiry.add(this.diry);
            pdirz.add(this.dirz);
            pdir.add(pdirx);
            pdir.add(pdiry);
            pdir.add(pdirz);
            this.color = new JButton("color");
            JPanel pcolor = new JPanel();
            pcolor.setLayout(new GridBagLayout());
            pcolor.add((Component)this.color, gc);
            this.setLayout(new BoxLayout(this, 0));
            this.add(ptype);
            this.add(ppos);
            this.add(pdir);
            this.add(pcolor);
            this.type.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    if (LightSourceEditor.this.type.getSelectedItem().equals(LightSourceEditor.this.types[0])) {
                        LightSourceEditor.this.posx.setEnabled(false);
                        LightSourceEditor.this.posy.setEnabled(false);
                        LightSourceEditor.this.posz.setEnabled(false);
                        LightSourceEditor.this.dirx.setEnabled(false);
                        LightSourceEditor.this.diry.setEnabled(false);
                        LightSourceEditor.this.dirz.setEnabled(false);
                        LightSourceEditor.this.color.setEnabled(false);
                    } else if (LightSourceEditor.this.type.getSelectedItem().equals(LightSourceEditor.this.types[1])) {
                        LightSourceEditor.this.posx.setEnabled(true);
                        LightSourceEditor.this.posy.setEnabled(true);
                        LightSourceEditor.this.posz.setEnabled(true);
                        LightSourceEditor.this.dirx.setEnabled(false);
                        LightSourceEditor.this.diry.setEnabled(false);
                        LightSourceEditor.this.dirz.setEnabled(false);
                        LightSourceEditor.this.color.setEnabled(true);
                    } else if (LightSourceEditor.this.type.getSelectedItem().equals(LightSourceEditor.this.types[2])) {
                        LightSourceEditor.this.posx.setEnabled(false);
                        LightSourceEditor.this.posy.setEnabled(false);
                        LightSourceEditor.this.posz.setEnabled(false);
                        LightSourceEditor.this.dirx.setEnabled(true);
                        LightSourceEditor.this.diry.setEnabled(true);
                        LightSourceEditor.this.dirz.setEnabled(true);
                        LightSourceEditor.this.color.setEnabled(true);
                    } else if (LightSourceEditor.this.type.getSelectedItem().equals(LightSourceEditor.this.types[3])) {
                        LightSourceEditor.this.posx.setEnabled(false);
                        LightSourceEditor.this.posy.setEnabled(false);
                        LightSourceEditor.this.posz.setEnabled(false);
                        LightSourceEditor.this.dirx.setEnabled(false);
                        LightSourceEditor.this.diry.setEnabled(false);
                        LightSourceEditor.this.dirz.setEnabled(false);
                        LightSourceEditor.this.color.setEnabled(true);
                    }
                }
            });
            this.setValue();
        }

        private void setValue() {
            String[] foo2;
            String light_prefix = "light" + String.valueOf(this.ID + 1) + "_";
            try {
                String strtype = LightEditor.this.gp.getProperty(String.valueOf(light_prefix) + "type");
                this.type.setSelectedItem(strtype);
            }
            catch (Exception strtype) {
                // empty catch block
            }
            try {
                foo2 = LightEditor.this.gp.getProperty(String.valueOf(light_prefix) + "position").split(",");
                this.posx.setText(foo2[0]);
                this.posy.setText(foo2[1]);
                this.posz.setText(foo2[2]);
            }
            catch (Exception foo2) {
                // empty catch block
            }
            try {
                foo2 = LightEditor.this.gp.getProperty(String.valueOf(light_prefix) + "direction").split(",");
                this.dirx.setText(foo2[0]);
                this.diry.setText(foo2[1]);
                this.dirz.setText(foo2[2]);
            }
            catch (Exception foo3) {
                // empty catch block
            }
            try {
                String[] co = LightEditor.this.gp.getProperty(String.valueOf(light_prefix) + "color").split(",");
                Color col = new Color(Float.parseFloat(co[0]), Float.parseFloat(co[1]), Float.parseFloat(co[2]));
                this.color.setBackground(col);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.color.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    JColorChooser colorchooser = new JColorChooser();
                    Color col = LightSourceEditor.this.color.getBackground();
                    Color colo = JColorChooser.showDialog(LightEditor.this.parent, "Choose", col);
                    if (colo != null) {
                        LightSourceEditor.this.color.setBackground(colo);
                    }
                }
            });
        }

        void save() {
            String z;
            String y;
            String x2;
            String light_prefix = "light" + String.valueOf(this.ID + 1) + "_";
            LightEditor.this.gp.setProperty(String.valueOf(light_prefix) + "type", this.type.getSelectedItem().toString());
            try {
                x2 = this.posx.getText().trim();
                y = this.posy.getText().trim();
                z = this.posz.getText().trim();
                LightEditor.this.gp.setProperty(String.valueOf(light_prefix) + "position", String.valueOf(x2) + "," + y + "," + z);
            }
            catch (Exception x2) {
                // empty catch block
            }
            try {
                x2 = this.dirx.getText().trim();
                y = this.diry.getText().trim();
                z = this.dirz.getText().trim();
                LightEditor.this.gp.setProperty(String.valueOf(light_prefix) + "direction", String.valueOf(x2) + "," + y + "," + z);
            }
            catch (Exception x3) {
                // empty catch block
            }
            Color c = this.color.getBackground();
            String red = String.valueOf((float)c.getRed() / 255.0f);
            String green = String.valueOf((float)c.getGreen() / 255.0f);
            String blue = String.valueOf((float)c.getBlue() / 255.0f);
            LightEditor.this.gp.setProperty(String.valueOf(light_prefix) + "color", String.valueOf(red) + "," + green + "," + blue);
        }
    }
}

