/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.frame;

import ciss.phase_viewer.acviewer.Animater;
import ciss.phase_viewer.acviewer.ConfigData;
import ciss.phase_viewer.acviewer.ConfigDataManager;
import ciss.phase_viewer.acviewer.ConfigDataUpdateEvent;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.Stoppable;
import ciss.phase_viewer.common.Resources;
import ciss.phase_viewer.common.SimpleHeavyGUI;
import ciss.phase_viewer.plugins.viewer.frame.MovieMaker;
import ciss.phase_viewer.plugins.viewer.frame.MovieMakerPanel;
import ciss.phase_viewer.primitiveguis.ValueSlider;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.apache.log4j.Logger;

public class FramePanel
extends SimpleHeavyGUI
implements Runnable,
Stoppable,
ConfigData {
    private static Logger logger = Logger.getLogger((String)FramePanel.class.getName());
    private MainPanel parent;
    private Vector frames;
    private int currentFrame = 0;
    private int numFrames = 0;
    private ConfigDataManager mCD;
    private ValueSlider frameSlider;
    private JTextField skip;
    private int numskip = 1;
    private int amari = 0;
    private JSlider frameRate;
    private Animater animater;
    private boolean update = false;
    private JToggleButton bounce;
    private JPanel specifypanel;
    private JPanel cont;
    private JPanel frameSliderPanel;
    private JButton next;
    private JButton previous;
    private JButton rewind;
    private JButton lastframe;
    private JButton animate;
    private boolean imDoingit = false;

    public FramePanel(MainPanel parent) {
        super("frames", "movie maker", "close", new Dimension(400, 300));
        this.parent = parent;
        this.frames = parent.getFramesAC();
        this.parent.addDisposeOnExit(this);
        this.numFrames = this.frames.size();
        this.mCD = parent.getCD();
        this.animater = parent.getAssociatedAnimater();
        TitledBorder title = new TitledBorder("number of frames: " + String.valueOf(this.numFrames));
        this.cont.setBorder(title);
        this.init();
        this.setVisible(true);
    }

    private void init() {
        this.mCD.register(this);
        this.frameSlider = new ValueSlider(0, this.frames.size() - 1, 0);
        this.frameSlider.addValueSliderListener(new ValueSliderListener(){

            @Override
            public void valueSliderValueChanged() {
                int cf = (int)FramePanel.this.frameSlider.getValue();
                FramePanel.this.currentFrame = cf;
                FramePanel.this.animater.setFrame(FramePanel.this.currentFrame);
            }
        });
        this.frameSlider.setTitleForBorder("specify frame no.");
        this.frameSlider.setOrientation(ValueSlider.VERTICAL);
        this.currentFrame = this.animater.getCurrentFrame();
        this.frameSlider.setValueInt(this.currentFrame);
        this.frameSliderPanel.add(this.frameSlider);
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent ev) {
                FramePanel.this.close();
            }
        });
    }

    private void close() {
        this.mCD.removeConfigData(this);
    }

    private void setEnableBtns(boolean bool) {
        this.next.setEnabled(bool);
        this.previous.setEnabled(bool);
        this.rewind.setEnabled(bool);
        this.lastframe.setEnabled(bool);
        this.animate.setEnabled(bool);
    }

    @Override
    public JPanel createMainPanel() {
        this.cont = new JPanel();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        String icondir = "/org/javalobby/icons/20x20/";
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        this.next = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRForward.gif"));
        this.next.setToolTipText("next frame");
        this.previous = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRBack.gif"));
        this.previous.setToolTipText("previous frame");
        this.rewind = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRBegin.gif"));
        this.rewind.setToolTipText("rewind to first frame");
        this.lastframe = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/VCREnd.gif"));
        this.lastframe.setToolTipText("skip to last frame");
        this.skip = new JTextField(5);
        this.skip.setText("1");
        this.skip.setToolTipText("specify the number of frames to skip on each redraw");
        this.animate = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRPlay.gif"));
        this.animate.setToolTipText("start");
        JButton stop = new JButton(Resources.getIcon("/org/javalobby/icons/20x20/VCRStop.gif"));
        stop.setToolTipText("stop");
        this.bounce = new JToggleButton(Resources.getIcon("/org/javalobby/icons/20x20/Widen.gif"));
        this.bounce.setToolTipText("enable 'bounce'");
        buttons.add(this.animate);
        buttons.add(this.bounce);
        buttons.add(stop);
        buttons.add(this.previous);
        buttons.add(this.next);
        buttons.add(this.rewind);
        buttons.add(this.lastframe);
        this.cont.add(buttons);
        JPanel skippanel = new JPanel();
        skippanel.setBorder(new TitledBorder("skip"));
        skippanel.add(this.skip);
        this.frameSliderPanel = new JPanel();
        this.frameSliderPanel.setLayout(new BoxLayout(this.frameSliderPanel, 0));
        this.frameSliderPanel.add(skippanel);
        this.cont.add(this.frameSliderPanel);
        JLabel sliderLabel = new JLabel("frame rate", 0);
        sliderLabel.setAlignmentX(0.5f);
        int min = 0;
        int max = 100;
        int init = 50;
        this.frameRate = new JSlider(0, min, max, init);
        this.frameRate.setMajorTickSpacing(10);
        this.frameRate.setPaintTicks(true);
        this.frameRate.setPaintLabels(true);
        this.cont.add(sliderLabel);
        this.cont.add(this.frameRate);
        this.animate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePanel.this.anim();
            }
        });
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePanel.this.update = false;
                FramePanel.this.animater.setSleep(false);
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePanel.this.update = false;
                FramePanel.this.calCurrFrame(true);
                FramePanel.this.animater.setFrame(FramePanel.this.currentFrame);
                FramePanel.this.frameSlider.setValueInt(FramePanel.this.currentFrame);
            }
        });
        this.previous.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePanel.this.update = false;
                FramePanel.this.calCurrFrame(false);
                FramePanel.this.animater.setFrame(FramePanel.this.currentFrame);
                FramePanel.this.frameSlider.setValueInt(FramePanel.this.currentFrame);
            }
        });
        this.rewind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePanel.this.currentFrame = 0;
                FramePanel.this.animater.setFrame(FramePanel.this.currentFrame);
                FramePanel.this.frameSlider.setValueInt(FramePanel.this.currentFrame);
            }
        });
        this.lastframe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FramePanel.this.currentFrame = FramePanel.this.numFrames - 1;
                FramePanel.this.animater.setFrame(FramePanel.this.currentFrame);
                FramePanel.this.frameSlider.setValueInt(FramePanel.this.currentFrame);
            }
        });
        this.frameRate.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (!FramePanel.this.frameRate.getValueIsAdjusting()) {
                    int frame = FramePanel.this.frameRate.getValue();
                    int frame_ = 250;
                    if (frame != 0) {
                        frame_ = 250 / frame;
                    }
                    FramePanel.this.animater.setFrameRate(frame_);
                }
            }
        });
        this.skip.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                try {
                    FramePanel.this.numskip = Integer.parseInt(FramePanel.this.skip.getText().trim());
                    if (FramePanel.this.numskip < 0 || FramePanel.this.numskip >= FramePanel.this.numFrames) {
                        FramePanel.this.numskip = 1;
                    }
                    FramePanel.this.animater.setSkip(FramePanel.this.numskip);
                    FramePanel.this.amari = FramePanel.this.numFrames % FramePanel.this.numskip;
                }
                catch (Exception exc) {
                    FramePanel.this.numskip = 1;
                }
            }
        });
        return this.cont;
    }

    private void anim() {
        new Thread(this).start();
    }

    private void calCurrFrame(boolean forward) {
        if (forward) {
            this.currentFrame += this.numskip;
            if (this.currentFrame >= this.numFrames) {
                this.currentFrame = this.amari;
            }
        } else {
            this.currentFrame -= this.numskip;
            if (this.currentFrame < 0) {
                this.currentFrame = this.frames.size() + this.currentFrame;
            }
        }
    }

    @Override
    public void run() {
        this.imDoingit = true;
        boolean reverse = false;
        this.update = true;
        this.animater.setSleep(true);
        this.setEnableBtns(false);
        int initframe = this.currentFrame;
        int frameshown = 1;
        while (this.update) {
            this.currentFrame = reverse ? (this.currentFrame -= this.numskip) : (this.currentFrame += this.numskip);
            if (this.currentFrame >= this.numFrames) {
                if (this.bounce.isSelected()) {
                    reverse = true;
                    this.currentFrame = this.currentFrame - this.amari - 1;
                } else {
                    this.currentFrame = this.amari;
                }
            }
            if (this.currentFrame < 0) {
                reverse = false;
                this.currentFrame = 0;
            }
            this.animater.setFrame(this.currentFrame);
            if (frameshown % 5 == 0) {
                this.frameSlider.setValueInt(this.currentFrame);
                frameshown = 1;
                continue;
            }
            ++frameshown;
        }
        this.frameSlider.setValueInt(this.currentFrame);
        this.setEnableBtns(true);
    }

    @Override
    protected boolean action() {
        try {
            String parentDir = this.parent.getData().getParentDir();
            String projdir = System.getProperty("user.dir");
            if (parentDir != null && new File(parentDir).exists()) {
                projdir = parentDir;
            }
            logger.debug((Object)("projdir: " + projdir));
            MovieMakerPanel mmp = new MovieMakerPanel(new MovieMaker(this.animater), projdir);
            Point location = this.getLocation();
            this.parent.addDisposeOnExit(mmp);
            mmp.setVisible(true);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return true;
    }

    @Override
    public void destructor() {
        this.update = false;
        this.imDoingit = false;
    }

    @Override
    public void stop() {
        this.update = false;
        this.imDoingit = false;
    }

    @Override
    public void configDataUpdate(boolean rescaleOnUpdate, ConfigDataUpdateEvent e) {
        this.configDataUpdate();
    }

    @Override
    public boolean needsUpdate() {
        return true;
    }

    @Override
    public void configDataUpdate() {
    }
}

