/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon.resultsviewerpanel.parsers;

import ciss.phase_viewer.outputinterface.OutputParser;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Output000Parser
extends OutputParser {
    private Logger logger = Logger.getLogger((String)Output000Parser.class.getName());
    public static final String OSCILLATOR = "oscillator";
    private final String oscillatorTag = "!* oscillator strength per electron";
    private String oscillator = "(not available)";
    public static final String ALL_KPOINTS = "all kpoints";
    private final String allKpointsTag = "All kpoints have been calculated";
    private String allKpoints = "no";
    public static final String LIST_OF_BAND = "list of band numbers";
    private final String listOfBandTag = "---------- list of band numbers for each spin ----------";
    private Vector list_of_band;
    boolean b_list_of_band = false;
    public static final String BANDGAP = "band gap";
    private final String bandGapTag = "---------- band gap ---------";
    private String bandGap = "(not available)";
    private boolean b_bandgap = false;
    public static final String STATIC_TENSOR = "static tensor";
    private final String staticTensorTag = "<< UVSOR-Epsilon   FINALIAZTION STARTS";
    private String staticTensor = "(not available)";
    private boolean b_static = false;
    public static final String EFFECTIVE_MASS = "effective mass";
    private final String effectiveMassTag = "---------- effective mass calculation ----------";
    private String effectiveMass = "(not available)";
    private boolean b_effective = false;

    public Output000Parser(String fileName) {
        super(fileName);
        this.invokeNewThread = false;
        this.logger.debug((Object)("fileName: " + fileName));
    }

    @Override
    protected boolean parse() {
        String line = "";
        try {
            try {
                while ((line = this.reader.readLine()) != null) {
                    this.parseLine(line.trim());
                }
            }
            catch (Exception exception) {
                try {
                    this.reader.close();
                }
                catch (Exception exception2) {}
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private void parseLine(String line) {
        String tmpline2;
        if (line.startsWith("!* oscillator strength per electron")) {
            String[] osc = line.split("=");
            try {
                this.oscillator = osc[1].trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (line.startsWith("All kpoints have been calculated")) {
            this.allKpoints = "yes";
        }
        if (line.startsWith("---------- list of band numbers for each spin ----------") && !this.b_list_of_band) {
            int count = 0;
            if (this.list_of_band == null) {
                this.list_of_band = new Vector();
            }
            try {
                while (count < 10) {
                    tmpline2 = this.reader.readLine();
                    if (tmpline2.trim().length() == 0) continue;
                    if (!tmpline2.trim().startsWith("total number of electron")) {
                        this.list_of_band.addElement(tmpline2.trim());
                        ++count;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception tmpline2) {
                // empty catch block
            }
            this.b_list_of_band = true;
        }
        if (line.startsWith("---------- band gap ---------") && !this.b_bandgap) {
            int count = 0;
            this.bandGap = "";
            try {
                while (count < 8) {
                    tmpline2 = this.reader.readLine().trim();
                    tmpline2 = tmpline2.replaceAll("!\\*", "");
                    String[] tmp = tmpline2.split("\\s+");
                    String tmptmp = "";
                    int i = 0;
                    while (i < tmp.length) {
                        tmptmp = String.valueOf(tmptmp) + tmp[i] + " ";
                        ++i;
                    }
                    this.bandGap = String.valueOf(this.bandGap) + tmptmp + System.getProperty("line.separator");
                    ++count;
                }
            }
            catch (Exception tmpline3) {
                // empty catch block
            }
            this.b_bandgap = true;
        }
        if (line.startsWith("<< UVSOR-Epsilon   FINALIAZTION STARTS")) {
            int count = 0;
            this.staticTensor = "";
            try {
                while (count < 13) {
                    tmpline2 = this.reader.readLine().trim();
                    if (!tmpline2.startsWith("<< UVSOR-Epsilon")) {
                        if (!tmpline2.startsWith("!* static dielectric constant") && !tmpline2.startsWith("xx") && !tmpline2.startsWith("xy") && !tmpline2.startsWith("yx") && !tmpline2.startsWith("yy") && !tmpline2.startsWith("zx") && !tmpline2.startsWith("zy") && !tmpline2.startsWith("Static") && !tmpline2.startsWith("SHG")) continue;
                        this.staticTensor = String.valueOf(this.staticTensor) + tmpline2 + System.getProperty("line.separator");
                        continue;
                    }
                    break;
                }
            }
            catch (Exception tmpline4) {
                // empty catch block
            }
        }
        if (line.startsWith("---------- effective mass calculation ----------")) {
            int count = 0;
            this.effectiveMass = String.valueOf(line) + System.getProperty("line.separator");
            while (count < 100) {
                try {
                    tmpline2 = this.reader.readLine().trim();
                    if (tmpline2.startsWith("!* ispin in tmsq")) break;
                    this.effectiveMass = String.valueOf(this.effectiveMass) + tmpline2 + System.getProperty("line.separator");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String[] getGenericData(String key) {
        if (key.equals(OSCILLATOR)) {
            return new String[]{this.oscillator};
        }
        if (key.equals(ALL_KPOINTS)) {
            return new String[]{this.allKpoints};
        }
        if (key.equals(LIST_OF_BAND)) {
            if (this.list_of_band == null) {
                return new String[]{"(not available)"};
            }
            Object[] ret = new String[this.list_of_band.size()];
            this.list_of_band.copyInto(ret);
            return ret;
        }
        if (key.equals(BANDGAP)) {
            return new String[]{this.bandGap};
        }
        if (key.equals(STATIC_TENSOR)) {
            return new String[]{this.staticTensor};
        }
        if (key.equals(EFFECTIVE_MASS)) {
            return new String[]{this.effectiveMass};
        }
        return super.getGenericData(key);
    }

    @Override
    public String getCurrentMessage() {
        return null;
    }
}

