/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.uvsorepsilon;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jobcontrol.JobController;
import ciss.phase_viewer.scripting.scriptreplace.ScriptReplaceRules;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class EpsilonScriptReplaceRules
extends ScriptReplaceRules {
    private Logger logger = Logger.getLogger((String)EpsilonScriptReplaceRules.class.getName());
    private final String __EPSILON__ = "__EPSILON__";
    private String[] keys = new String[]{"__EPSILON__"};

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public String replace(String file, Document document, boolean overwrite2) {
        if (document == null || !document.hasRootElement()) {
            this.logger.error((Object)"invalid document");
            return null;
        }
        Element jobcontrol = document.getRootElement().getChild(JobController.JOBCONTROL);
        if (jobcontrol == null) {
            this.logger.error((Object)"invalid jobcontrol element");
            return null;
        }
        Element targethost = jobcontrol.getChild("targethost");
        if (targethost == null) {
            this.logger.error((Object)"invalid 'targethost' element");
            return null;
        }
        Element env = targethost.getChild("env");
        if (env == null) {
            this.logger.error((Object)"invalid 'env' element");
            return null;
        }
        String[] keys = this.getKeys();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (key.equals("__EPSILON__")) {
                String bindir = MyElement.decode(env.getChildTextTrim("bindir"));
                String eps = String.valueOf(bindir) + "/epsmain";
                if (bindir == null || bindir.trim().length() == 0) {
                    eps = "ekcal";
                }
                if (targethost.getTextTrim().equals("localhost") && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
                    eps = String.valueOf(Utils.escapeBackSlash(bindir)) + "\\\\" + "epsmain.exe";
                    if (bindir == null || bindir.trim().length() == 0) {
                        eps = "epsmain.exe";
                    }
                }
                file = file.replaceAll(key, eps);
            }
            ++i;
        }
        if (!targethost.getTextTrim().equals("localhost") || !System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            file = file.replaceAll("\\r", "");
        }
        return file;
    }

    @Override
    public String replace(String script, Document document) {
        return this.replace(script, document, false);
    }
}

