/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.stdout;

import ciss.phase_viewer.outputinterface.OutputParser;
import ciss.phase_viewer.outputinterface.OutputParserListener;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutGeneralPanel;
import ciss.phase_viewer.plugins.projectmanipulator.phase.resultsviewerpanel.stdout.StdoutSCFPanel;
import ciss.phase_viewer.projectbrowser.ProjectBrowserUtils;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.tools.NoFilePanel;
import ciss.phase_viewer.projectbrowser.tools.StdoutBasePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class StdoutSubPanel
extends JPanel
implements OutputParserListener {
    private Logger logger = Logger.getLogger((String)StdoutSubPanel.class.getName());
    private ProjectInfo projectInfo;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private StdoutGeneralPanel generalPanel;
    private StdoutSCFPanel tableData;
    private String stdoutFileName = "output000";
    private Vector panels = new Vector();
    private Vector stdoutVector = new Vector();
    private Class[] clazz;
    private JComboBox comboStdout;
    private JTextField filtertext;
    private JCheckBox caseCheckbox;
    private OutputParser outputParser;

    public StdoutSubPanel(ProjectInfo projectInfo) {
        this.projectInfo = projectInfo;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
        this.add(this.createSelector());
        this.createPanels();
        this.add(Box.createVerticalGlue());
    }

    public StdoutSubPanel(ProjectInfo projectInfo, Class[] clazz) {
        this.projectInfo = projectInfo;
        this.clazz = clazz;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
        this.add(this.createSelector());
        this.createPanels();
        this.add(Box.createVerticalGlue());
    }

    private void createPanels() {
        if (this.stdoutVector.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.panels.size()) {
            StdoutBasePanel panel = (StdoutBasePanel)this.panels.elementAt(i);
            this.tabbedPane.addTab(panel.getDescription(), panel);
            ++i;
        }
        this.add(this.tabbedPane);
    }

    private JPanel createSelector() {
        if (this.stdoutVector.size() == 0) {
            return new NoFilePanel("F_OUT");
        }
        JPanel p = new JPanel();
        JLabel select = new JLabel(" select stdout file:          ");
        p.add(select);
        this.comboStdout = new JComboBox(this.stdoutVector);
        this.comboStdout.setSize(select.getSize());
        p.add(this.comboStdout);
        JPanel peditor2 = new JPanel();
        peditor2.setLayout(new BoxLayout(peditor2, 0));
        JLabel label_filter = new JLabel(" filter: ");
        this.filtertext = new JTextField(10);
        this.caseCheckbox = new JCheckBox("ignore case");
        JButton btneditor = new JButton("editor");
        peditor2.add(label_filter);
        peditor2.add(this.filtertext);
        peditor2.add(this.caseCheckbox);
        peditor2.add(btneditor);
        p.add(peditor2);
        btneditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StdoutSubPanel.this.stdoutFileName = String.valueOf(StdoutSubPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + StdoutSubPanel.this.comboStdout.getSelectedItem();
                String tmp = StdoutSubPanel.this.filtertext.getText();
                if (tmp == null || tmp.trim().length() == 0) {
                    ProjectBrowserUtils.bootTextViewer(StdoutSubPanel.this.stdoutFileName);
                } else {
                    ProjectBrowserUtils.bootTextViewer(StdoutSubPanel.this.stdoutFileName, tmp.trim(), StdoutSubPanel.this.caseCheckbox.isSelected());
                }
            }
        });
        this.comboStdout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                StdoutSubPanel.this.stdoutFileName = String.valueOf(StdoutSubPanel.this.projectInfo.getProjectDirectory()) + System.getProperty("file.separator") + StdoutSubPanel.this.comboStdout.getSelectedItem();
                if (new File(StdoutSubPanel.this.stdoutFileName).exists()) {
                    StdoutSubPanel.this.update(StdoutSubPanel.this.stdoutFileName);
                }
            }
        });
        this.comboStdout.setSelectedIndex(this.comboStdout.getItemCount() - 1);
        this.update(this.stdoutFileName);
        return p;
    }

    private void init() {
        String name = this.projectInfo.getChaseFileManager().getFile("F_OUT").getDefaultName().getValue();
        String projdir = this.projectInfo.getProjectDirectory();
        String path = String.valueOf(projdir) + System.getProperty("file.separator") + name;
        String[] stdoutfiles = new File(projdir).list();
        if (stdoutfiles == null || stdoutfiles.length == 0) {
            this.logger.debug((Object)("dir " + projdir + " is null/not a directory."));
            return;
        }
        this.stdoutVector = new Vector();
        int i = 0;
        while (i < stdoutfiles.length) {
            this.logger.debug((Object)("file : " + stdoutfiles[i] + " the name to be matched: " + name));
            if (stdoutfiles[i].trim().matches(name.trim())) {
                this.stdoutVector.addElement(stdoutfiles[i]);
                this.logger.debug((Object)"found stdout file!");
            }
            ++i;
        }
        if (this.stdoutVector.size() == 0) {
            this.logger.debug((Object)"no stdout files...");
            return;
        }
        if (this.clazz == null) {
            return;
        }
        i = 0;
        while (i < this.clazz.length) {
            try {
                StdoutBasePanel obj = (StdoutBasePanel)this.clazz[i].newInstance();
                this.panels.add(obj);
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            ++i;
        }
    }

    private void update(String fileName) {
        this.logger.debug((Object)("updating stdout; stdout file : " + fileName));
        this.outputParser = this.projectInfo.getOutputInterface().getParser("F_OUT", fileName, this);
        this.outputParser.setParsed(false);
        this.outputParser.doParse();
    }

    @Override
    public void parseFinished() {
        int i = 0;
        while (i < this.panels.size()) {
            this.logger.debug((Object)("clazz: " + this.panels.get(i).getClass().toString()));
            StdoutBasePanel p = (StdoutBasePanel)this.panels.elementAt(i);
            if (p != null) {
                p.setOutputParser(this.outputParser);
            }
            ++i;
        }
    }
}

