/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.projectmanipulator.stdout;

import ciss.phase_viewer.plugins.projectmanipulator.stdout.TFJobStatus;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class JobStatusMonitor
extends JPanel {
    private Logger logger = Logger.getLogger((String)JobStatusMonitor.class.getName());
    private TFJobStatus status;
    private TFJobStatus iteration;
    private TFJobStatus iter_ionic;
    private TFJobStatus iter_elec;
    private TFJobStatus elapsed_time;
    private final int REFRESH = 5000;
    private String statusFile;
    private String extension;
    private String baseDir;

    public JobStatusMonitor(ProjectInfo projectInfo) {
        this.baseDir = String.valueOf(projectInfo.getProjectDirectory()) + System.getProperty("file.separator");
        this.setLayout(new GridLayout(1, 1));
        this.createPanels();
        Timer timer = new Timer(5000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JobStatusMonitor.this.reload();
            }
        });
        timer.start();
    }

    public void setExtension(String extension) {
        this.extension = extension;
        this.statusFile = String.valueOf(this.baseDir) + "jobstatus" + extension;
        if (extension.trim().length() == 0) {
            this.logger.warn((Object)"jobstatus file: not available");
            return;
        }
        this.reload();
    }

    private void reload() {
        if (this.statusFile == null) {
            return;
        }
        File file = new File(this.statusFile);
        boolean statusExists = file.exists();
        String str_status = new String();
        String str_iteration = new String();
        String str_iter_ionic = new String();
        String str_iter_elec = new String();
        String str_elapsed_time = new String();
        if (statusExists) {
            this.addPanels();
            try {
                String readString;
                BufferedReader br = new BufferedReader(new FileReader(this.statusFile));
                while ((readString = br.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(readString, "=");
                    if (st.countTokens() < 2) continue;
                    String ident = st.nextToken().trim();
                    if (ident.equals("status")) {
                        str_status = st.nextToken().trim();
                        continue;
                    }
                    if (ident.equals("iteration")) {
                        str_iteration = st.nextToken().trim();
                        continue;
                    }
                    if (ident.equals("iter_ionic")) {
                        str_iter_ionic = st.nextToken().trim();
                        continue;
                    }
                    if (ident.equals("iter_elec")) {
                        str_iter_elec = st.nextToken().trim();
                        continue;
                    }
                    if (!ident.equals("elapsed_time")) continue;
                    str_elapsed_time = st.nextToken().trim();
                }
                br.close();
                this.setBorder(new TitledBorder("jobstatus file: jobstatus" + this.extension));
            }
            catch (Exception exc) {
                this.logger.error((Object)("failed read from: " + this.statusFile));
            }
        } else {
            this.addPanels();
            this.setBorder(new TitledBorder("jobstatus file: jobstatus" + this.extension + " not available"));
        }
        this.status.setText(str_status);
        this.iteration.setText(str_iteration);
        this.iter_ionic.setText(str_iter_ionic);
        this.iter_elec.setText(str_iter_elec);
        this.elapsed_time.setText(str_elapsed_time);
        this.revalidate();
    }

    private void createPanels() {
        this.setLayout(new BoxLayout(this, 0));
        int width = 13;
        this.status = new TFJobStatus("status", width);
        this.iteration = new TFJobStatus("iteration", width);
        this.iter_ionic = new TFJobStatus("iter_ionic", width);
        this.iter_elec = new TFJobStatus("iter_elec", width);
        this.elapsed_time = new TFJobStatus("elapsed_time", width);
    }

    private void addPanels() {
        this.removeAll();
        JPanel p = new JPanel();
        p.add(this.status);
        p.add(this.iteration);
        p.add(this.iter_ionic);
        p.add(this.iter_elec);
        p.add(this.elapsed_time);
        this.add(p);
    }

    private void addNotAvailable() {
        this.removeAll();
        this.add(new JLabel("(jobstatus" + this.extension + ": not available)"));
    }
}

